<?php
require_once 'config/database.php';
require_once 'config/auth.php';
require_once 'includes/functions.php';

$slug = $_GET['slug'] ?? '';
$post = getPostBySlug($slug);

if (!$post) {
    header('HTTP/1.0 404 Not Found');
    $page_title = 'Post Not Found';
    include 'includes/header.php';
    echo '<div class="container"><div class="error-message"><h1>Post Not Found</h1><p>The post you are looking for does not exist.</p><a href="home.php" class="btn btn-primary">Back to Home</a></div></div>';
    include 'includes/footer.php';
    exit;
}

$page_title = $post['title'];
include 'includes/header.php';
?>

<article class="post-single">
    <div class="container">
        <div class="post-header">
            <h2 class="post-title"><?php echo htmlspecialchars($post['title']); ?></h2>
        </div>

        <div class="post-meta-container" style="text-align:center; margin-bottom: 2rem;">
            <span class="author-name">By <?php echo htmlspecialchars($post['author_name']); ?></span><br>
            <time class="post-date"><?php echo formatDate($post['created_at']); ?></time>
        </div>

        <div class="post-content">
            <?php echo $post['content']; ?>
        </div>

        <div class="post-footer">
            <div class="post-tags">
                <span class="tag"><?php echo htmlspecialchars($post['category_name']); ?></span>
            </div>
            <div class="post-share">
                <span>Share:</span>
                <a href="#" class="share-link"><i class="fab fa-twitter"></i></a>
                <a href="#" class="share-link"><i class="fab fa-facebook"></i></a>
                <a href="#" class="share-link"><i class="fab fa-linkedin"></i></a>
            </div>
        </div>

    </div>
    <div class="post-navigation" style="margin-top: 2rem; text-align: center;">
        <a href="javascript:history.back()" class="btn btn-secondary" style="margin-right: 1rem;">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <a href="home.php" class="btn btn-primary">
            <i class="fas fa-home"></i> Home
        </a>
    </div>
</article>
<?php include 'includes/footer.php'; ?>