-- Add logo table for storing site logo information
-- This allows administrators to upload and manage the site logo

CREATE TABLE IF NOT EXISTS site_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(50) UNIQUE NOT NULL,
    setting_value TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insert default logo setting
INSERT INTO site_settings (setting_key, setting_value) VALUES
('site_logo', 'fas fa-newspaper'),
('site_name', 'Mutalex Academy');

-- Create uploads directory for logos
-- Note: This would need to be created manually or via file system