<?php
require_once '../config/database.php';
require_once '../config/auth.php';
require_once '../includes/functions.php';

requireLogin();

$pdo = getDB();

// Get statistics
$total_posts = $pdo->query("SELECT COUNT(*) FROM posts")->fetchColumn();
$published_posts = $pdo->query("SELECT COUNT(*) FROM posts WHERE status = 'published'")->fetchColumn();
$draft_posts = $pdo->query("SELECT COUNT(*) FROM posts WHERE status = 'draft'")->fetchColumn();
$total_categories = $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn();

// Get recent posts
$recent_posts = $pdo->query("SELECT p.*, c.name as category_name FROM posts p 
                           LEFT JOIN categories c ON p.category_id = c.id 
                           ORDER BY p.created_at DESC LIMIT 5")->fetchAll();

$page_title = 'Dashboard';
include 'includes/admin_header.php';
?>

<div class="dashboard-stats">
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-file-alt"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $total_posts; ?></h3>
            <p>Total Posts</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-eye"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $published_posts; ?></h3>
            <p>Published</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-edit"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $draft_posts; ?></h3>
            <p>Drafts</p>
        </div>
    </div>
    <div class="stat-card">
        <div class="stat-icon">
            <i class="fas fa-folder"></i>
        </div>
        <div class="stat-info">
            <h3><?php echo $total_categories; ?></h3>
            <p>Categories</p>
        </div>
    </div>
</div>

<div class="dashboard-content">
    <div class="dashboard-section">
        <h2>Recent Posts</h2>
        <div class="posts-list">
            <?php foreach ($recent_posts as $post): ?>
                <div class="post-item">
                    <div class="post-info">
                        <h4><?php echo htmlspecialchars($post['title']); ?></h4>
                        <p class="post-meta">
                            <span class="category"><?php echo htmlspecialchars($post['category_name'] ?? 'Uncategorized'); ?></span>
                            <span class="status status-<?php echo $post['status']; ?>"><?php echo ucfirst($post['status']); ?></span>
                            <span class="date"><?php echo formatDate($post['created_at']); ?></span>
                        </p>
                    </div>
                    <div class="post-actions">
                        <a href="edit_post.php?id=<?php echo $post['id']; ?>" class="btn btn-sm">Edit</a>
                        <a href="../post.php?slug=<?php echo urlencode($post['slug']); ?>" class="btn btn-sm btn-secondary" target="_blank">View</a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <a href="posts.php" class="btn btn-primary">View All Posts</a>
    </div>

    <div class="dashboard-section">
        <h2>Quick Actions</h2>
        <div class="quick-actions">
            <a href="add_post.php" class="action-card">
                <i class="fas fa-plus"></i>
                <span>New Post</span>
            </a>
            <a href="posts.php" class="action-card">
                <i class="fas fa-list"></i>
                <span>Manage Posts</span>
            </a>
            <a href="categories.php" class="action-card">
                <i class="fas fa-folder"></i>
                <span>Categories</span>
            </a>
            <a href="../home.php" class="action-card">
                <i class="fas fa-eye"></i>
                <span>View Site</span>
            </a>
        </div>
    </div>
</div>

<?php include 'includes/admin_footer.php'; ?>