<?php
require_once 'config/database.php';
require_once 'config/auth.php';
require_once 'includes/functions.php';

$page_title = 'Home';
$search = $_GET['search'] ?? null;
$posts = getAllPublishedPosts(6, $search);
$categories = getCategories();
$announcements = getActiveAnnouncements();
$slideshow_images = json_decode(getSiteSetting('slideshow_images') ?: '[]', true);

include 'includes/header.php';
?>


<section class="hero">
    <div class="container">
        <div class="hero-content">
            <h1 class="hero-title">Welcome to Mutalex Academy</h1>
            <p class="hero-description">Your premier destination for the latest news, insightful articles,journals and academic content for various professional courses . Stay informed and inspired with our diverse content.</p>
            <?php if (!empty($announcements)): ?>
                <div id="hero-announcement" class="hero-announcement">
                    <div class="announcement-content">
                        <i class="fas fa-bullhorn"></i>
                        <span id="announcement-text"><?php echo htmlspecialchars($announcements[0]['title']); ?>: <?php echo htmlspecialchars($announcements[0]['content']); ?></span>
                        <button class="announcement-close" onclick="closeHeroAnnouncement()">&times;</button>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php if (!empty($slideshow_images)): ?>
<section class="slideshow">
    <div class="slideshow-container">
        <?php foreach ($slideshow_images as $index => $image): ?>
            <div class="slide <?php echo $index === 0 ? 'active' : ''; ?>" style="background-image: url('<?php echo htmlspecialchars($image['url']); ?>');">
                <?php if (!empty(trim($image['title'] ?? '')) || !empty(trim($image['description'] ?? ''))): ?>
                <div class="slide-content">
                    <h2><?php echo htmlspecialchars($image['title'] ?? ''); ?></h2>
                    <p><?php echo htmlspecialchars($image['description'] ?? ''); ?></p>
                </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
        <button class="prev-btn" onclick="changeSlide(-1)">&#10094;</button>
        <button class="next-btn" onclick="changeSlide(1)">&#10095;</button>
        <div class="dots">
            <?php foreach ($slideshow_images as $index => $image): ?>
                <span class="dot <?php echo $index === 0 ? 'active' : ''; ?>" onclick="currentSlide(<?php echo $index; ?>)"></span>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<section class="search-section">
    <div class="container">
        <div class="search-container">
            <form method="GET" action="" class="search-form">
                <input type="text" name="search" placeholder="Search posts..." value="<?php echo htmlspecialchars($search ?? ''); ?>" class="search-input">
                <button type="submit" class="search-btn">
                    <i class="fas fa-search"></i> Search
                </button>
                <?php if ($search): ?>
                    <a href="home" class="clear-search">Clear Search</a>
                <?php endif; ?>
            </form>
        </div>
    </div>
</section>

<section class="categories-section">
    <div class="container">
        <h2 class="section-title">Explore Categories</h2>
        <div class="categories-grid">
            <?php foreach ($categories as $category): ?>
                <div class="category-card">
                    <div class="category-icon">
                        <?php
                        $icons = ['news' => 'fas fa-newspaper', 'articles' => 'fas fa-file-alt', 'journals' => 'fas fa-book'];
                        echo '<i class="' . ($icons[$category['slug']] ?? 'fas fa-folder') . '"></i>';
                        ?>
                    </div>
                    <h3><?php echo htmlspecialchars($category['name']); ?></h3>
                    <p><?php echo htmlspecialchars($category['description']); ?></p>
                    <a href="category.php?cat=<?php echo urlencode($category['slug']); ?>" class="category-link">
                        Explore <?php echo htmlspecialchars($category['name']); ?>
                        <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<section class="featured-posts">
    <div class="container">
        <h2 class="section-title">
            <?php echo $search ? 'Search Results for "' . htmlspecialchars($search) . '"' : 'Latest Posts'; ?>
        </h2>
        
        <?php if ($posts): ?>
            <div class="posts-grid">
                <?php foreach ($posts as $post): ?>
                    <article class="post-card">
                        <div class="post-header">
                            <span class="post-category"><?php echo htmlspecialchars($post['category_name']); ?></span>
                            <time class="post-date"><?php echo formatDate($post['created_at']); ?></time>
                        </div>
                        <h3 class="post-title">
                            <a href="post.php?slug=<?php echo urlencode($post['slug']); ?>">
                                <?php echo htmlspecialchars($post['title']); ?>
                            </a>
                        </h3>
                        <p class="post-excerpt">
                            <?php echo htmlspecialchars(truncateText(strip_tags($post['content']))); ?>
                        </p>
                        <div class="post-footer">
                            <span class="post-author">By <?php echo htmlspecialchars($post['author_name']); ?></span>
                            <a href="post.php?slug=<?php echo urlencode($post['slug']); ?>" class="read-more">
                                Read More <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="no-posts">
                <i class="fas fa-newspaper"></i>
                <p>
                    <?php if ($search): ?>
                        No posts found matching "<?php echo htmlspecialchars($search); ?>". Try different keywords.
                    <?php else: ?>
                        No posts available at the moment. Check back soon!
                    <?php endif; ?>
                </p>
            </div>
        <?php endif; ?>
    </div>
</section>


<script>
<?php if (!empty($announcements)): ?>
const announcements = <?php echo json_encode($announcements); ?>;
let currentAnnouncementIndex = 0;

function showAnnouncement(index) {
    if (index < announcements.length) {
        const announcement = announcements[index];
        document.getElementById('announcement-text').textContent = announcement.title + ': ' + announcement.content;
    }
}

function closeHeroAnnouncement() {
    document.getElementById('hero-announcement').style.display = 'none';
}

// Cycle through announcements every 10 seconds
setInterval(() => {
    currentAnnouncementIndex = (currentAnnouncementIndex + 1) % announcements.length;
    showAnnouncement(currentAnnouncementIndex);
}, 10000);
<?php endif; ?>

<?php if (!empty($slideshow_images)): ?>
let slideIndex = 0;
const slides = document.getElementsByClassName("slide");
const dots = document.getElementsByClassName("dot");

function showSlides(n) {
    if (n >= slides.length) { slideIndex = 0; }
    if (n < 0) { slideIndex = slides.length - 1; }

    // Hide all slides
    for (let i = 0; i < slides.length; i++) {
        slides[i].classList.remove("active");
        slides[i].style.opacity = "0";
    }

    // Remove active class from all dots
    for (let i = 0; i < dots.length; i++) {
        dots[i].classList.remove("active");
    }

    // Show current slide
    slides[slideIndex].classList.add("active");
    slides[slideIndex].style.opacity = "1";

    // Activate corresponding dot
    if (dots[slideIndex]) {
        dots[slideIndex].classList.add("active");
    }

}

function changeSlide(n) {
    showSlides(slideIndex += n);
}

function currentSlide(n) {
    showSlides(slideIndex = n);
}

// Auto slide every 5 seconds
setInterval(() => {
    changeSlide(1);
}, 5000);

// Initialize first slide
showSlides(0);
<?php endif; ?>
</script>

<?php include 'includes/footer.php'; ?>