<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Mutalex Academy</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="nav-wrapper">
                <div class="logo">
                    <a href="home">
                        <?php
                        $siteLogo = getSiteSetting('site_logo') ?: 'fas fa-newspaper';
                        $siteName = getSiteSetting('site_name') ?: 'Mutalex Academy';

                        if (strpos($siteLogo, 'assets/images/') === 0) {
                            echo '<img src="' . htmlspecialchars($siteLogo) . '" alt="' . htmlspecialchars($siteName) . '" class="site-logo">';
                        } else {
                            echo '<i class="' . htmlspecialchars($siteLogo) . '"></i>';
                        }
                        echo htmlspecialchars($siteName);
                        ?>
                    </a>
                </div>
                <nav class="nav">
                    <a href="home" class="nav-link">Home</a>
                    <a href="category?cat=news" class="nav-link">News</a>
                    <a href="category?cat=articles" class="nav-link">Articles</a>
                    <a href="category?cat=journals" class="nav-link">Journals</a>
                    <a href="/blogg/survey/take.php" class="nav-link">Surveys</a>
                    <?php if (isLoggedIn()): ?>
                        <a href="admin/dashboard" class="nav-link">Admin</a>
                        <a href="logout" class="nav-link">Logout</a>
                    <?php else: ?>
                        <a href="login" class="nav-link">Login</a>
                    <?php endif; ?>
                </nav>
                <div class="mobile-menu-toggle">
                    <i class="fas fa-bars"></i>
                </div>
            </div>
        </div>
    </header>

    <main class="main">