<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Sample courses data
    $courses = [
        [
            'title' => 'Introduction to PHP Programming',
            'slug' => 'introduction-to-php-programming',
            'description' => 'Learn PHP from basics to advanced concepts including OOP, databases, and web development.',
            'short_description' => 'Master PHP programming fundamentals and build dynamic web applications.',
            'instructor_id' => 1,
            'category_id' => 1,
            'level' => 'beginner',
            'duration_hours' => 20,
            'is_free' => true,
            'status' => 'published'
        ],
        [
            'title' => 'Web Development with HTML, CSS & JavaScript',
            'slug' => 'web-development-html-css-javascript',
            'description' => 'Complete guide to modern web development using HTML5, CSS3, and JavaScript.',
            'short_description' => 'Build responsive websites with modern web technologies.',
            'instructor_id' => 1,
            'category_id' => 1,
            'level' => 'beginner',
            'duration_hours' => 25,
            'is_free' => true,
            'status' => 'published'
        ],
        [
            'title' => 'Digital Marketing Fundamentals',
            'slug' => 'digital-marketing-fundamentals',
            'description' => 'Learn essential digital marketing strategies including SEO, social media, and content marketing.',
            'short_description' => 'Master digital marketing techniques to grow your online presence.',
            'instructor_id' => 1,
            'category_id' => 4,
            'level' => 'intermediate',
            'duration_hours' => 15,
            'is_free' => false,
            'status' => 'published'
        ]
    ];

    // Check if courses already exist and insert if not
    foreach ($courses as $course) {
        $stmt = $pdo->prepare("SELECT id FROM courses WHERE slug = ?");
        $stmt->execute([$course['slug']]);
        $existing = $stmt->fetch();

        if (!$existing) {
            $stmt = $pdo->prepare("
                INSERT INTO courses (
                    title, slug, description, short_description, instructor_id,
                    category_id, level, duration_hours, is_free, status, created_at, updated_at
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
            ");
            $stmt->execute([
                $course['title'],
                $course['slug'],
                $course['description'],
                $course['short_description'],
                $course['instructor_id'],
                $course['category_id'],
                $course['level'],
                $course['duration_hours'],
                $course['is_free'],
                $course['status']
            ]);
            echo "Added course: " . $course['title'] . "\n";
        } else {
            echo "Course already exists: " . $course['title'] . "\n";
        }
    }

    // Ensure course categories exist
    $categories = [
        ['name' => 'Technology', 'slug' => 'technology', 'icon' => 'fas fa-code', 'color' => '#007bff'],
        ['name' => 'Marketing', 'slug' => 'marketing', 'icon' => 'fas fa-bullhorn', 'color' => '#fd7e14']
    ];

    foreach ($categories as $category) {
        $stmt = $pdo->prepare("SELECT id FROM course_categories WHERE slug = ?");
        $stmt->execute([$category['slug']]);
        $existing = $stmt->fetch();

        if (!$existing) {
            $stmt = $pdo->prepare("
                INSERT INTO course_categories (name, slug, description, icon, color, is_active)
                VALUES (?, ?, '', ?, ?, TRUE)
            ");
            $stmt->execute([
                $category['name'],
                $category['slug'],
                $category['icon'],
                $category['color']
            ]);
            echo "Added category: " . $category['name'] . "\n";
        }
    }

    echo "Sample courses setup completed successfully.\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>