<?php
// AI Configuration for Mutalex Academy LMS
// OpenAI GPT-4o Integration Settings

// OpenAI API Configuration
define('OPENAI_API_KEY', getenv('OPENAI_API_KEY') ?: 'your-openai-api-key-here');
define('OPENAI_MODEL', 'gpt-4o');
define('OPENAI_MAX_TOKENS', 4000);
define('OPENAI_TEMPERATURE', 0.7);

// Rate Limiting
define('AI_RATE_LIMIT_REQUESTS', 100); // requests per hour
define('AI_RATE_LIMIT_WINDOW', 3600); // 1 hour in seconds

// Cost Management
define('AI_DAILY_COST_LIMIT', 50.00); // USD per day
define('AI_MONTHLY_COST_LIMIT', 1000.00); // USD per month

// Feature-specific settings
$ai_config = [
    'content_analysis' => [
        'enabled' => true,
        'max_content_length' => 10000, // characters
        'analysis_types' => ['readability', 'engagement', 'objectives_alignment']
    ],
    'question_generation' => [
        'enabled' => true,
        'max_questions_per_request' => 10,
        'supported_types' => ['mcq_single', 'mcq_multiple', 'true_false', 'short_answer', 'essay']
    ],
    'essay_evaluation' => [
        'enabled' => true,
        'max_essay_length' => 5000, // characters
        'rubric_types' => ['content', 'structure', 'grammar', 'originality']
    ],
    'content_summarization' => [
        'enabled' => true,
        'max_content_length' => 20000, // characters
        'summary_lengths' => ['short', 'medium', 'long']
    ],
    'learning_path' => [
        'enabled' => true,
        'max_recommendations' => 5
    ],
    'performance_analysis' => [
        'enabled' => true,
        'analysis_periods' => ['week', 'month', 'quarter']
    ],
    'accessibility' => [
        'enabled' => true,
        'standards' => ['WCAG_2_1', 'ADA', 'Section_508']
    ],
    'translation' => [
        'enabled' => true,
        'supported_languages' => ['es', 'fr', 'de', 'zh', 'ja', 'ar', 'pt', 'ru', 'hi']
    ]
];

// AI Usage Tracking
define('AI_LOG_REQUESTS', true);
define('AI_LOG_COSTS', true);

// Error Handling
define('AI_MAX_RETRIES', 3);
define('AI_RETRY_DELAY', 1000); // milliseconds

// Cache Settings
define('AI_CACHE_ENABLED', true);
define('AI_CACHE_TTL', 3600); // 1 hour

// Get OpenAI client instance
function getOpenAIClient() {
    static $client = null;

    if ($client === null) {
        $client = OpenAI::client(OPENAI_API_KEY);
    }

    return $client;
}

// Check if AI feature is enabled
function isAIFeatureEnabled($feature) {
    global $ai_config;
    return isset($ai_config[$feature]['enabled']) && $ai_config[$feature]['enabled'];
}

// Get AI feature configuration
function getAIConfig($feature = null) {
    global $ai_config;

    if ($feature === null) {
        return $ai_config;
    }

    return $ai_config[$feature] ?? null;
}

// Rate limiting check
function checkAIRateLimit($userId) {
    // This would be implemented with database tracking
    // For now, return true (allow)
    return true;
}

// Cost tracking
function trackAICost($cost, $feature, $userId) {
    if (!AI_LOG_COSTS) return;

    // Log cost to database
    // Implementation would go here
}

// Log AI request
function logAIRequest($feature, $userId, $tokens, $cost = null) {
    if (!AI_LOG_REQUESTS) return;

    // Log to database
    // Implementation would go here
}
?>