<?php
/**
 * LMS Configuration Settings
 * Contains all LMS-specific configuration options
 */

// LMS General Settings
$lms_config = [
    'site_name' => 'Mutalex Academy',
    'site_description' => 'Your premier destination for online learning and professional development',
    'contact_email' => 'support@mutalexacademy.com',
    'support_phone' => '+1-234-567-8900',

    // Course Settings
    'max_free_courses_per_user' => 5,
    'max_enrollments_per_course' => 1000,
    'course_completion_threshold' => 80, // percentage
    'certificate_validity_years' => 2,

    // Payment Settings
    'currency' => 'USD',
    'payment_gateways' => [
        'enabled' => ['paynow', 'paypal', 'stripe'],
        'default' => 'paynow'
    ],
    'tax_rate' => 0.0, // 0% tax

    // Exam Settings
    'exam_time_limit_buffer' => 5, // minutes added to time limit
    'max_exam_attempts' => 3,
    'passing_score_default' => 70, // percentage
    'auto_submit_exam' => true,

    // Learning Settings
    'lesson_time_tracking' => true,
    'progress_auto_save' => true,
    'notes_enabled' => true,
    'discussion_forums' => false, // future feature

    // Notification Settings
    'email_notifications' => [
        'enrollment_confirmation' => true,
        'course_completion' => true,
        'exam_results' => true,
        'payment_receipts' => true,
        'weekly_progress' => false
    ],

    // File Upload Settings
    'max_file_size' => 10 * 1024 * 1024, // 10MB
    'allowed_file_types' => ['pdf', 'doc', 'docx', 'txt', 'jpg', 'jpeg', 'png', 'zip'],
    'upload_path' => '../uploads/',

    // Security Settings
    'session_timeout' => 3600, // 1 hour
    'max_login_attempts' => 5,
    'password_min_length' => 8,
    'require_strong_passwords' => true,

    // Analytics Settings
    'analytics_enabled' => true,
    'track_user_progress' => true,
    'anonymize_data' => false,

    // Integration Settings
    'api_enabled' => true,
    'webhooks_enabled' => true,
    'third_party_integrations' => [
        'google_analytics' => false,
        'facebook_pixel' => false,
        'mailchimp' => false
    ]
];

// Course Categories Configuration
$course_categories_config = [
    'default_categories' => [
        [
            'name' => 'Technology',
            'slug' => 'technology',
            'description' => 'Programming, software development, and tech skills',
            'icon' => 'fas fa-code',
            'color' => '#007bff',
            'is_active' => true
        ],
        [
            'name' => 'Business',
            'slug' => 'business',
            'description' => 'Management, entrepreneurship, and professional development',
            'icon' => 'fas fa-briefcase',
            'color' => '#28a745',
            'is_active' => true
        ],
        [
            'name' => 'Design',
            'slug' => 'design',
            'description' => 'Graphic design, UI/UX, and creative skills',
            'icon' => 'fas fa-palette',
            'color' => '#e83e8c',
            'is_active' => true
        ],
        [
            'name' => 'Marketing',
            'slug' => 'marketing',
            'description' => 'Digital marketing, SEO, and advertising strategies',
            'icon' => 'fas fa-bullhorn',
            'color' => '#fd7e14',
            'is_active' => true
        ],
        [
            'name' => 'Data Science',
            'slug' => 'data-science',
            'description' => 'Data analysis, machine learning, and statistics',
            'icon' => 'fas fa-chart-line',
            'color' => '#6f42c1',
            'is_active' => true
        ],
        [
            'name' => 'Languages',
            'slug' => 'languages',
            'description' => 'Learn new languages and communication skills',
            'icon' => 'fas fa-language',
            'color' => '#20c997',
            'is_active' => true
        ]
    ]
];

// User Role Permissions
$lms_permissions = [
    'guest' => [
        'view_public_courses' => true,
        'enroll_free_courses' => false,
        'take_exams' => false,
        'view_progress' => false,
        'download_certificates' => false
    ],
    'student' => [
        'view_public_courses' => true,
        'enroll_free_courses' => true,
        'enroll_paid_courses' => true,
        'take_exams' => true,
        'view_progress' => true,
        'download_certificates' => true,
        'leave_reviews' => true,
        'access_learning_interface' => true
    ],
    'instructor' => [
        'view_public_courses' => true,
        'create_courses' => true,
        'edit_own_courses' => true,
        'create_exams' => true,
        'grade_assignments' => true,
        'view_student_progress' => true,
        'manage_enrollments' => true,
        'view_analytics' => true,
        'moderate_reviews' => true
    ],
    'admin' => [
        'all_permissions' => true,
        'manage_users' => true,
        'manage_site_settings' => true,
        'view_all_analytics' => true,
        'manage_payments' => true,
        'system_administration' => true
    ]
];

// Email Templates Configuration
$email_templates = [
    'enrollment_confirmation' => [
        'subject' => 'Welcome to {course_title}!',
        'template' => 'enrollment_confirmation.html'
    ],
    'course_completion' => [
        'subject' => 'Congratulations! You completed {course_title}',
        'template' => 'course_completion.html'
    ],
    'exam_results' => [
        'subject' => 'Your exam results for {exam_title}',
        'template' => 'exam_results.html'
    ],
    'payment_receipt' => [
        'subject' => 'Payment receipt for {item_name}',
        'template' => 'payment_receipt.html'
    ],
    'certificate_issued' => [
        'subject' => 'Your certificate for {course_title} is ready',
        'template' => 'certificate_issued.html'
    ]
];

// API Configuration
$api_config = [
    'version' => 'v1',
    'rate_limiting' => [
        'enabled' => true,
        'max_requests_per_hour' => 1000,
        'max_requests_per_minute' => 60
    ],
    'authentication' => [
        'token_expiry' => 3600, // 1 hour
        'refresh_token_expiry' => 2592000 // 30 days
    ],
    'endpoints' => [
        'courses' => '/api/v1/courses',
        'enrollments' => '/api/v1/enrollments',
        'progress' => '/api/v1/progress',
        'exams' => '/api/v1/exams',
        'analytics' => '/api/v1/analytics'
    ]
];

// Feature Flags (for gradual rollout of features)
$feature_flags = [
    'certificates' => true,
    'gamification' => false, // badges, points, leaderboards
    'live_classes' => false,
    'mobile_app' => false,
    'offline_learning' => false,
    'ai_tutoring' => false,
    'peer_learning' => false,
    'corporate_training' => false
];

// Return configuration arrays
return [
    'lms' => $lms_config,
    'categories' => $course_categories_config,
    'permissions' => $lms_permissions,
    'emails' => $email_templates,
    'api' => $api_config,
    'features' => $feature_flags
];