<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Create cart_items table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS cart_items (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            item_type ENUM('course', 'exam') NOT NULL DEFAULT 'course',
            item_id INT NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            UNIQUE KEY unique_cart_item (user_id, item_type, item_id),
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Add index for better performance
    $pdo->exec("CREATE INDEX idx_cart_user_type ON cart_items (user_id, item_type)");
    $pdo->exec("CREATE INDEX idx_cart_created ON cart_items (created_at)");

    echo "Cart migration applied successfully.";
} catch (PDOException $e) {
    echo "Error applying cart migration: " . $e->getMessage();
}
?>