<?php
require_once 'config/database.php';

try {
    $pdo = getDB();

    // Enable Paynow sandbox
    $pdo->exec("
        UPDATE payment_gateway_settings
        SET is_active = 1
        WHERE gateway_name = 'paynow' AND gateway_type = 'sandbox'
    ");

    // Enable PayPal sandbox
    $pdo->exec("
        UPDATE payment_gateway_settings
        SET is_active = 1
        WHERE gateway_name = 'paypal' AND gateway_type = 'sandbox'
    ");

    echo "Payment gateways enabled successfully.\n";
    echo "Note: Please update the API credentials in the payment_gateway_settings table:\n";
    echo "- For Paynow: Set api_key (Integration ID) and api_secret (Integration Key)\n";
    echo "- For PayPal: Set api_key (Client ID) and api_secret (Client Secret)\n";
    echo "You can obtain these from your Paynow and PayPal developer accounts.\n";

} catch (PDOException $e) {
    echo "Error enabling payment gateways: " . $e->getMessage();
}
?>