<?php
require_once __DIR__ . '/functions.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Mutalex Academy</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="nav-wrapper">
                <div class="logo">
                    <a href="<?php echo BASE_URL; ?>home">
                        <?php
                        $siteLogo = getSiteSetting('site_logo') ?: 'fas fa-newspaper';
                        $siteName = getSiteSetting('site_name') ?: 'Mutalex Academy';

                        if (strpos($siteLogo, 'assets/images/') === 0) {
                            echo '<img src="' . BASE_URL . htmlspecialchars($siteLogo) . '" alt="' . htmlspecialchars($siteName) . '" class="site-logo">';
                        } else {
                            echo '<i class="' . htmlspecialchars($siteLogo) . '"></i>';
                        }
                        echo htmlspecialchars($siteName);
                        ?>
                    </a>
                </div>
                <nav class="nav">
                     <a href="<?php echo BASE_URL; ?>home" class="nav-link">Home</a>
                     <a href="<?php echo BASE_URL; ?>courses/catalog.php" class="nav-link">Courses</a>
                     <a href="<?php echo BASE_URL; ?>category?cat=news" class="nav-link">News</a>
                     <a href="<?php echo BASE_URL; ?>category?cat=articles" class="nav-link">Articles</a>
                     <a href="<?php echo BASE_URL; ?>category?cat=journals" class="nav-link">Journals</a>
                     <a href="<?php echo BASE_URL; ?>blogg/survey/take.php" class="nav-link">Surveys</a>
                     <?php if (isLoggedIn()): ?>
                         <?php
                         // Get cart count for logged-in users
                         $cartCount = 0;
                         if (isLoggedIn()) {
                             try {
                                 $db = getDB();
                                 $userId = $_SESSION['user_id'];
                                 $stmt = $db->prepare("SELECT COUNT(*) as count FROM cart_items WHERE user_id = ? AND item_type = 'course'");
                                 $stmt->execute([$userId]);
                                 $result = $stmt->fetch(PDO::FETCH_ASSOC);
                                 $cartCount = $result['count'] ?? 0;
                             } catch (Exception $e) {
                                 $cartCount = 0;
                             }
                         }
                         ?>
                         <?php if (basename($_SERVER['SCRIPT_NAME']) !== 'home.php'): ?>
                         <a href="<?php echo BASE_URL; ?>cart.php" class="nav-link cart-link">
                             <i class="fas fa-shopping-cart me-1"></i>Cart
                             <?php if ($cartCount > 0): ?>
                                 <span class="cart-count"><?php echo $cartCount; ?></span>
                             <?php endif; ?>
                         </a>
                         <?php endif; ?>
                         <?php if (basename($_SERVER['SCRIPT_NAME']) !== 'home.php'): ?>
                             <a href="<?php echo BASE_URL; ?>profile.php" class="nav-link">Profile</a>
                         <?php endif; ?>
                         <?php if (hasRole('admin')): ?>
                             <a href="<?php echo BASE_URL; ?>admin/dashboard.php" class="nav-link">Admin Dashboard</a>
                         <?php elseif (hasRole('instructor')): ?>
                             <a href="<?php echo BASE_URL; ?>instructor/dashboard.php" class="nav-link">Instructor Dashboard</a>
                         <?php elseif (hasRole('student')): ?>
                             <a href="<?php echo BASE_URL; ?>student/dashboard.php" class="nav-link">Student Dashboard</a>
                         <?php endif; ?>
                         <a href="<?php echo BASE_URL; ?>logout.php" class="nav-link">Logout</a>
                     <?php else: ?>
                         <a href="<?php echo BASE_URL; ?>login.php" class="nav-link">Login</a>
                     <?php endif; ?>
                 </nav>
                <div class="mobile-menu-toggle">
                    <i class="fas fa-bars"></i>
                </div>
            </div>
        </div>
    </header>


    <main class="main">