<?php
require_once '../../includes/middleware.php';
requirePermission('create_course');
require_once '../../config/database.php';
require_once '../../includes/functions.php';

$db = getDB();
$userId = $_SESSION['user_id'];

// Get all available courses for instructors to edit
$stmt = $db->prepare("
    SELECT c.*, COUNT(ce.id) as enrollment_count,
           COUNT(CASE WHEN ce.status = 'completed' THEN 1 END) as completion_count,
           AVG(ce.progress_percentage) as avg_progress,
           COUNT(DISTINCT ce.student_id) as unique_students
    FROM courses c
    LEFT JOIN course_enrollments ce ON c.id = ce.course_id
    GROUP BY c.id
    ORDER BY c.created_at DESC
");
$stmt->execute();
$courses = $stmt->fetchAll();

// Get course categories for filter
$stmt = $db->query("SELECT * FROM course_categories WHERE is_active = 1 ORDER BY name");
$categories = $stmt->fetchAll();

$page_title = 'Available Courses - Mutalex Academy';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <!-- Load Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen">

<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white shadow-lg rounded-lg p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-3xl font-bold text-gray-900">Available Courses</h1>
            <div class="flex gap-3">
                <a href="../dashboard.php" class="bg-gray-600 text-white px-4 py-2 rounded-lg hover:bg-gray-700 transition">
                    <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                </a>
                <a href="new.php" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">
                    <i class="fas fa-plus mr-2"></i>Create New Course
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="mb-6 flex flex-wrap gap-4">
            <select class="border border-gray-300 rounded-md px-3 py-2">
                <option>All Status</option>
                <option>Published</option>
                <option>Draft</option>
            </select>
            <select class="border border-gray-300 rounded-md px-3 py-2">
                <option>All Categories</option>
                <?php foreach ($categories as $category): ?>
                    <option><?php echo htmlspecialchars($category['name']); ?></option>
                <?php endforeach; ?>
            </select>
            <input type="text" placeholder="Search courses..." class="border border-gray-300 rounded-md px-3 py-2 flex-1 min-w-[200px]">
        </div>

        <!-- Courses Grid -->
        <?php if (empty($courses)): ?>
            <div class="text-center py-12">
                <i class="fas fa-book fa-4x text-gray-300 mb-4"></i>
                <h3 class="text-xl font-semibold text-gray-600 mb-2">No courses yet</h3>
                <p class="text-gray-500 mb-6">Start by creating your first course to share knowledge with students.</p>
                <a href="new.php" class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition font-medium">
                    <i class="fas fa-plus mr-2"></i>Create Your First Course
                </a>
            </div>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($courses as $course): ?>
                    <div class="bg-white border border-gray-200 rounded-lg shadow-md overflow-hidden hover:shadow-lg transition">
                        <!-- Course Thumbnail -->
                        <div class="h-48 bg-gray-200 flex items-center justify-center">
                            <?php if ($course['thumbnail']): ?>
                                <img src="../../<?php echo htmlspecialchars($course['thumbnail']); ?>" alt="Course thumbnail" class="w-full h-full object-cover">
                            <?php else: ?>
                                <i class="fas fa-book text-4xl text-gray-400"></i>
                            <?php endif; ?>
                        </div>

                        <!-- Course Content -->
                        <div class="p-4">
                            <div class="flex justify-between items-start mb-2">
                                <h3 class="text-lg font-semibold text-gray-900 truncate"><?php echo htmlspecialchars($course['title']); ?></h3>
                                <span class="text-xs font-medium px-2 py-1 rounded-full <?php echo $course['status'] === 'published' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'; ?>">
                                    <?php echo ucfirst($course['status']); ?>
                                </span>
                            </div>

                            <p class="text-sm text-gray-600 mb-3 line-clamp-2"><?php echo htmlspecialchars($course['short_description'] ?: 'No description'); ?></p>

                            <!-- Stats -->
                            <div class="grid grid-cols-3 gap-2 mb-4 text-center">
                                <div>
                                    <div class="text-lg font-bold text-blue-600"><?php echo $course['enrollment_count']; ?></div>
                                    <div class="text-xs text-gray-500">Students</div>
                                </div>
                                <div>
                                    <div class="text-lg font-bold text-purple-600"><?php echo $course['completion_count']; ?></div>
                                    <div class="text-xs text-gray-500">Completed</div>
                                </div>
                                <div>
                                    <div class="text-lg font-bold text-green-600"><?php echo round($course['avg_progress'] ?? 0); ?>%</div>
                                    <div class="text-xs text-gray-500">Avg Progress</div>
                                </div>
                            </div>

                            <!-- Actions -->
                            <div class="flex flex-wrap gap-2">
                                <a href="edit.php?id=<?php echo $course['id']; ?>" class="flex-1 bg-blue-600 text-white text-center py-2 px-3 rounded-md hover:bg-blue-700 transition text-sm font-medium">
                                    <i class="fas fa-edit mr-1"></i>Edit
                                </a>
                                <a href="lesson_editor.php?course_id=<?php echo $course['id']; ?>" class="flex-1 bg-green-600 text-white text-center py-2 px-3 rounded-md hover:bg-green-700 transition text-sm font-medium">
                                    <i class="fas fa-plus mr-1"></i>Add Lessons
                                </a>
                                <a href="../../courses/detail.php?id=<?php echo $course['id']; ?>" target="_blank" class="flex-1 bg-gray-600 text-white text-center py-2 px-3 rounded-md hover:bg-gray-700 transition text-sm font-medium">
                                    <i class="fas fa-eye mr-1"></i>Preview
                                </a>
                            </div>

                            <!-- Additional Actions -->
                            <div class="flex gap-2 mt-2">
                                <a href="analytics.php?id=<?php echo $course['id']; ?>" class="flex-1 bg-purple-600 text-white text-center py-2 px-3 rounded-md hover:bg-purple-700 transition text-sm font-medium">
                                    <i class="fas fa-chart-bar mr-1"></i>Analytics
                                </a>
                                <a href="lesson_preview.php?course_id=<?php echo $course['id']; ?>" class="flex-1 bg-indigo-600 text-white text-center py-2 px-3 rounded-md hover:bg-indigo-700 transition text-sm font-medium">
                                    <i class="fas fa-play mr-1"></i>Lesson Preview
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
// Add any interactive functionality here
document.addEventListener('DOMContentLoaded', function() {
    // Filter functionality can be added here
    console.log('Courses page loaded');
});
</script>

</body>
</html>