<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayExperienceContext;

/**
 * Builder for model ApplePayExperienceContext
 *
 * @see ApplePayExperienceContext
 */
class ApplePayExperienceContextBuilder
{
    /**
     * @var ApplePayExperienceContext
     */
    private $instance;

    private function __construct(ApplePayExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Apple Pay Experience Context Builder object.
     *
     * @param string $returnUrl
     * @param string $cancelUrl
     */
    public static function init(string $returnUrl, string $cancelUrl): self
    {
        return new self(new ApplePayExperienceContext($returnUrl, $cancelUrl));
    }

    /**
     * Initializes a new Apple Pay Experience Context object.
     */
    public function build(): ApplePayExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
