<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BillingCycleOverride;
use PaypalServerSdkLib\Models\SubscriptionPricingScheme;

/**
 * Builder for model BillingCycleOverride
 *
 * @see BillingCycleOverride
 */
class BillingCycleOverrideBuilder
{
    /**
     * @var BillingCycleOverride
     */
    private $instance;

    private function __construct(BillingCycleOverride $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Billing Cycle Override Builder object.
     *
     * @param int $sequence
     */
    public static function init(int $sequence): self
    {
        return new self(new BillingCycleOverride($sequence));
    }

    /**
     * Sets pricing scheme field.
     *
     * @param SubscriptionPricingScheme|null $value
     */
    public function pricingScheme(?SubscriptionPricingScheme $value): self
    {
        $this->instance->setPricingScheme($value);
        return $this;
    }

    /**
     * Sets total cycles field.
     *
     * @param int|null $value
     */
    public function totalCycles(?int $value): self
    {
        $this->instance->setTotalCycles($value);
        return $this;
    }

    /**
     * Initializes a new Billing Cycle Override object.
     */
    public function build(): BillingCycleOverride
    {
        return CoreHelper::clone($this->instance);
    }
}
