<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BlikExperienceContext;

/**
 * Builder for model BlikExperienceContext
 *
 * @see BlikExperienceContext
 */
class BlikExperienceContextBuilder
{
    /**
     * @var BlikExperienceContext
     */
    private $instance;

    private function __construct(BlikExperienceContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Blik Experience Context Builder object.
     */
    public static function init(): self
    {
        return new self(new BlikExperienceContext());
    }

    /**
     * Sets brand name field.
     *
     * @param string|null $value
     */
    public function brandName(?string $value): self
    {
        $this->instance->setBrandName($value);
        return $this;
    }

    /**
     * Sets locale field.
     *
     * @param string|null $value
     */
    public function locale(?string $value): self
    {
        $this->instance->setLocale($value);
        return $this;
    }

    /**
     * Sets shipping preference field.
     *
     * @param string|null $value
     */
    public function shippingPreference(?string $value): self
    {
        $this->instance->setShippingPreference($value);
        return $this;
    }

    /**
     * Sets return url field.
     *
     * @param string|null $value
     */
    public function returnUrl(?string $value): self
    {
        $this->instance->setReturnUrl($value);
        return $this;
    }

    /**
     * Sets cancel url field.
     *
     * @param string|null $value
     */
    public function cancelUrl(?string $value): self
    {
        $this->instance->setCancelUrl($value);
        return $this;
    }

    /**
     * Sets consumer ip field.
     *
     * @param string|null $value
     */
    public function consumerIp(?string $value): self
    {
        $this->instance->setConsumerIp($value);
        return $this;
    }

    /**
     * Sets consumer user agent field.
     *
     * @param string|null $value
     */
    public function consumerUserAgent(?string $value): self
    {
        $this->instance->setConsumerUserAgent($value);
        return $this;
    }

    /**
     * Initializes a new Blik Experience Context object.
     */
    public function build(): BlikExperienceContext
    {
        return CoreHelper::clone($this->instance);
    }
}
