<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CardVerificationDetails;
use PaypalServerSdkLib\Models\CardVerificationProcessorResponse;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model CardVerificationDetails
 *
 * @see CardVerificationDetails
 */
class CardVerificationDetailsBuilder
{
    /**
     * @var CardVerificationDetails
     */
    private $instance;

    private function __construct(CardVerificationDetails $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Card Verification Details Builder object.
     */
    public static function init(): self
    {
        return new self(new CardVerificationDetails());
    }

    /**
     * Sets network transaction id field.
     *
     * @param string|null $value
     */
    public function networkTransactionId(?string $value): self
    {
        $this->instance->setNetworkTransactionId($value);
        return $this;
    }

    /**
     * Sets date field.
     *
     * @param string|null $value
     */
    public function date(?string $value): self
    {
        $this->instance->setDate($value);
        return $this;
    }

    /**
     * Sets network field.
     *
     * @param string|null $value
     */
    public function network(?string $value): self
    {
        $this->instance->setNetwork($value);
        return $this;
    }

    /**
     * Sets time field.
     *
     * @param string|null $value
     */
    public function time(?string $value): self
    {
        $this->instance->setTime($value);
        return $this;
    }

    /**
     * Sets amount field.
     *
     * @param Money|null $value
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Sets processor response field.
     *
     * @param CardVerificationProcessorResponse|null $value
     */
    public function processorResponse(?CardVerificationProcessorResponse $value): self
    {
        $this->instance->setProcessorResponse($value);
        return $this;
    }

    /**
     * Sets three d secure field.
     *
     * @param mixed $value
     */
    public function threeDSecure($value): self
    {
        $this->instance->setThreeDSecure($value);
        return $this;
    }

    /**
     * Initializes a new Card Verification Details object.
     */
    public function build(): CardVerificationDetails
    {
        return CoreHelper::clone($this->instance);
    }
}
