<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CreateSubscriptionRequest;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PlanOverride;
use PaypalServerSdkLib\Models\SubscriberRequest;
use PaypalServerSdkLib\Models\SubscriptionApplicationContext;

/**
 * Builder for model CreateSubscriptionRequest
 *
 * @see CreateSubscriptionRequest
 */
class CreateSubscriptionRequestBuilder
{
    /**
     * @var CreateSubscriptionRequest
     */
    private $instance;

    private function __construct(CreateSubscriptionRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Create Subscription Request Builder object.
     *
     * @param string $planId
     */
    public static function init(string $planId): self
    {
        return new self(new CreateSubscriptionRequest($planId));
    }

    /**
     * Sets start time field.
     *
     * @param string|null $value
     */
    public function startTime(?string $value): self
    {
        $this->instance->setStartTime($value);
        return $this;
    }

    /**
     * Sets quantity field.
     *
     * @param string|null $value
     */
    public function quantity(?string $value): self
    {
        $this->instance->setQuantity($value);
        return $this;
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets subscriber field.
     *
     * @param SubscriberRequest|null $value
     */
    public function subscriber(?SubscriberRequest $value): self
    {
        $this->instance->setSubscriber($value);
        return $this;
    }

    /**
     * Sets auto renewal field.
     *
     * @param bool|null $value
     */
    public function autoRenewal(?bool $value): self
    {
        $this->instance->setAutoRenewal($value);
        return $this;
    }

    /**
     * Sets application context field.
     *
     * @param SubscriptionApplicationContext|null $value
     */
    public function applicationContext(?SubscriptionApplicationContext $value): self
    {
        $this->instance->setApplicationContext($value);
        return $this;
    }

    /**
     * Sets custom id field.
     *
     * @param string|null $value
     */
    public function customId(?string $value): self
    {
        $this->instance->setCustomId($value);
        return $this;
    }

    /**
     * Sets plan field.
     *
     * @param PlanOverride|null $value
     */
    public function plan(?PlanOverride $value): self
    {
        $this->instance->setPlan($value);
        return $this;
    }

    /**
     * Initializes a new Create Subscription Request object.
     */
    public function build(): CreateSubscriptionRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
