<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\MobileWebContext;

/**
 * Builder for model MobileWebContext
 *
 * @see MobileWebContext
 */
class MobileWebContextBuilder
{
    /**
     * @var MobileWebContext
     */
    private $instance;

    private function __construct(MobileWebContext $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Mobile Web Context Builder object.
     */
    public static function init(): self
    {
        return new self(new MobileWebContext());
    }

    /**
     * Sets return flow field.
     *
     * @param string|null $value
     */
    public function returnFlow(?string $value): self
    {
        $this->instance->setReturnFlow($value);
        return $this;
    }

    /**
     * Sets buyer user agent field.
     *
     * @param string|null $value
     */
    public function buyerUserAgent(?string $value): self
    {
        $this->instance->setBuyerUserAgent($value);
        return $this;
    }

    /**
     * Initializes a new Mobile Web Context object.
     */
    public function build(): MobileWebContext
    {
        return CoreHelper::clone($this->instance);
    }
}
