<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;

/**
 * Builder for model Money
 *
 * @see Money
 */
class MoneyBuilder
{
    /**
     * @var Money
     */
    private $instance;

    private function __construct(Money $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Money Builder object.
     *
     * @param string $currencyCode
     * @param string $value
     */
    public static function init(string $currencyCode, string $value): self
    {
        return new self(new Money($currencyCode, $value));
    }

    /**
     * Initializes a new Money object.
     */
    public function build(): Money
    {
        return CoreHelper::clone($this->instance);
    }
}
