<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\OrderTrackerItem;
use PaypalServerSdkLib\Models\OrderTrackerResponse;

/**
 * Builder for model OrderTrackerResponse
 *
 * @see OrderTrackerResponse
 */
class OrderTrackerResponseBuilder
{
    /**
     * @var OrderTrackerResponse
     */
    private $instance;

    private function __construct(OrderTrackerResponse $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Order Tracker Response Builder object.
     */
    public static function init(): self
    {
        return new self(new OrderTrackerResponse());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets status field.
     *
     * @param string|null $value
     */
    public function status(?string $value): self
    {
        $this->instance->setStatus($value);
        return $this;
    }

    /**
     * Sets items field.
     *
     * @param OrderTrackerItem[]|null $value
     */
    public function items(?array $value): self
    {
        $this->instance->setItems($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Sets create time field.
     *
     * @param string|null $value
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     *
     * @param string|null $value
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Initializes a new Order Tracker Response object.
     */
    public function build(): OrderTrackerResponse
    {
        return CoreHelper::clone($this->instance);
    }
}
