<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BillingCycle;
use PaypalServerSdkLib\Models\OneTimeCharge;
use PaypalServerSdkLib\Models\Plan;

/**
 * Builder for model Plan
 *
 * @see Plan
 */
class PlanBuilder
{
    /**
     * @var Plan
     */
    private $instance;

    private function __construct(Plan $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Plan Builder object.
     *
     * @param BillingCycle[] $billingCycles
     * @param OneTimeCharge $oneTimeCharges
     */
    public static function init(array $billingCycles, OneTimeCharge $oneTimeCharges): self
    {
        return new self(new Plan($billingCycles, $oneTimeCharges));
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Initializes a new Plan object.
     */
    public function build(): Plan
    {
        return CoreHelper::clone($this->instance);
    }
}
