<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ShippingInformation;
use PaypalServerSdkLib\Models\SimplePostalAddressCoarseGrained;

/**
 * Builder for model ShippingInformation
 *
 * @see ShippingInformation
 */
class ShippingInformationBuilder
{
    /**
     * @var ShippingInformation
     */
    private $instance;

    private function __construct(ShippingInformation $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Shipping Information Builder object.
     */
    public static function init(): self
    {
        return new self(new ShippingInformation());
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets method field.
     *
     * @param string|null $value
     */
    public function method(?string $value): self
    {
        $this->instance->setMethod($value);
        return $this;
    }

    /**
     * Sets address field.
     *
     * @param SimplePostalAddressCoarseGrained|null $value
     */
    public function address(?SimplePostalAddressCoarseGrained $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Sets secondary shipping address field.
     *
     * @param SimplePostalAddressCoarseGrained|null $value
     */
    public function secondaryShippingAddress(?SimplePostalAddressCoarseGrained $value): self
    {
        $this->instance->setSecondaryShippingAddress($value);
        return $this;
    }

    /**
     * Initializes a new Shipping Information object.
     */
    public function build(): ShippingInformation
    {
        return CoreHelper::clone($this->instance);
    }
}
