<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ExperienceContext;
use PaypalServerSdkLib\Models\SofortPaymentRequest;

/**
 * Builder for model SofortPaymentRequest
 *
 * @see SofortPaymentRequest
 */
class SofortPaymentRequestBuilder
{
    /**
     * @var SofortPaymentRequest
     */
    private $instance;

    private function __construct(SofortPaymentRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Sofort Payment Request Builder object.
     *
     * @param string $name
     * @param string $countryCode
     */
    public static function init(string $name, string $countryCode): self
    {
        return new self(new SofortPaymentRequest($name, $countryCode));
    }

    /**
     * Sets experience context field.
     *
     * @param ExperienceContext|null $value
     */
    public function experienceContext(?ExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new Sofort Payment Request object.
     */
    public function build(): SofortPaymentRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
