<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\LinkDescription;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PlanDetails;
use PaypalServerSdkLib\Models\Subscriber;
use PaypalServerSdkLib\Models\Subscription;
use PaypalServerSdkLib\Models\SubscriptionBillingInformation;

/**
 * Builder for model Subscription
 *
 * @see Subscription
 */
class SubscriptionBuilder
{
    /**
     * @var Subscription
     */
    private $instance;

    private function __construct(Subscription $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Builder object.
     */
    public static function init(): self
    {
        return new self(new Subscription());
    }

    /**
     * Sets id field.
     *
     * @param string|null $value
     */
    public function id(?string $value): self
    {
        $this->instance->setId($value);
        return $this;
    }

    /**
     * Sets plan id field.
     *
     * @param string|null $value
     */
    public function planId(?string $value): self
    {
        $this->instance->setPlanId($value);
        return $this;
    }

    /**
     * Sets start time field.
     *
     * @param string|null $value
     */
    public function startTime(?string $value): self
    {
        $this->instance->setStartTime($value);
        return $this;
    }

    /**
     * Sets quantity field.
     *
     * @param string|null $value
     */
    public function quantity(?string $value): self
    {
        $this->instance->setQuantity($value);
        return $this;
    }

    /**
     * Sets shipping amount field.
     *
     * @param Money|null $value
     */
    public function shippingAmount(?Money $value): self
    {
        $this->instance->setShippingAmount($value);
        return $this;
    }

    /**
     * Sets subscriber field.
     *
     * @param Subscriber|null $value
     */
    public function subscriber(?Subscriber $value): self
    {
        $this->instance->setSubscriber($value);
        return $this;
    }

    /**
     * Sets billing info field.
     *
     * @param SubscriptionBillingInformation|null $value
     */
    public function billingInfo(?SubscriptionBillingInformation $value): self
    {
        $this->instance->setBillingInfo($value);
        return $this;
    }

    /**
     * Sets create time field.
     *
     * @param string|null $value
     */
    public function createTime(?string $value): self
    {
        $this->instance->setCreateTime($value);
        return $this;
    }

    /**
     * Sets update time field.
     *
     * @param string|null $value
     */
    public function updateTime(?string $value): self
    {
        $this->instance->setUpdateTime($value);
        return $this;
    }

    /**
     * Sets custom id field.
     *
     * @param string|null $value
     */
    public function customId(?string $value): self
    {
        $this->instance->setCustomId($value);
        return $this;
    }

    /**
     * Sets plan overridden field.
     *
     * @param bool|null $value
     */
    public function planOverridden(?bool $value): self
    {
        $this->instance->setPlanOverridden($value);
        return $this;
    }

    /**
     * Sets plan field.
     *
     * @param PlanDetails|null $value
     */
    public function plan(?PlanDetails $value): self
    {
        $this->instance->setPlan($value);
        return $this;
    }

    /**
     * Sets links field.
     *
     * @param LinkDescription[]|null $value
     */
    public function links(?array $value): self
    {
        $this->instance->setLinks($value);
        return $this;
    }

    /**
     * Initializes a new Subscription object.
     */
    public function build(): Subscription
    {
        return CoreHelper::clone($this->instance);
    }
}
