<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\SubscriptionCardRequest;
use PaypalServerSdkLib\Models\SubscriptionsCardAttributes;

/**
 * Builder for model SubscriptionCardRequest
 *
 * @see SubscriptionCardRequest
 */
class SubscriptionCardRequestBuilder
{
    /**
     * @var SubscriptionCardRequest
     */
    private $instance;

    private function __construct(SubscriptionCardRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscription Card Request Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriptionCardRequest());
    }

    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets number field.
     *
     * @param string|null $value
     */
    public function number(?string $value): self
    {
        $this->instance->setNumber($value);
        return $this;
    }

    /**
     * Sets expiry field.
     *
     * @param string|null $value
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets security code field.
     *
     * @param string|null $value
     */
    public function securityCode(?string $value): self
    {
        $this->instance->setSecurityCode($value);
        return $this;
    }

    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets brand field.
     *
     * @param string|null $value
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     *
     * @param Address|null $value
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Sets attributes field.
     *
     * @param SubscriptionsCardAttributes|null $value
     */
    public function attributes(?SubscriptionsCardAttributes $value): self
    {
        $this->instance->setAttributes($value);
        return $this;
    }

    /**
     * Initializes a new Subscription Card Request object.
     */
    public function build(): SubscriptionCardRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
