<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CardCustomer;
use PaypalServerSdkLib\Models\CardVerification;
use PaypalServerSdkLib\Models\SubscriptionsCardAttributes;
use PaypalServerSdkLib\Models\VaultInstructionBase;

/**
 * Builder for model SubscriptionsCardAttributes
 *
 * @see SubscriptionsCardAttributes
 */
class SubscriptionsCardAttributesBuilder
{
    /**
     * @var SubscriptionsCardAttributes
     */
    private $instance;

    private function __construct(SubscriptionsCardAttributes $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Subscriptions Card Attributes Builder object.
     */
    public static function init(): self
    {
        return new self(new SubscriptionsCardAttributes());
    }

    /**
     * Sets customer field.
     *
     * @param CardCustomer|null $value
     */
    public function customer(?CardCustomer $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets vault field.
     *
     * @param VaultInstructionBase|null $value
     */
    public function vault(?VaultInstructionBase $value): self
    {
        $this->instance->setVault($value);
        return $this;
    }

    /**
     * Sets verification field.
     *
     * @param CardVerification|null $value
     */
    public function verification(?CardVerification $value): self
    {
        $this->instance->setVerification($value);
        return $this;
    }

    /**
     * Initializes a new Subscriptions Card Attributes object.
     */
    public function build(): SubscriptionsCardAttributes
    {
        return CoreHelper::clone($this->instance);
    }
}
