<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ApplePayRequestCard;
use PaypalServerSdkLib\Models\VaultApplePayRequest;

/**
 * Builder for model VaultApplePayRequest
 *
 * @see VaultApplePayRequest
 */
class VaultApplePayRequestBuilder
{
    /**
     * @var VaultApplePayRequest
     */
    private $instance;

    private function __construct(VaultApplePayRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vault Apple Pay Request Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultApplePayRequest());
    }

    /**
     * Sets token field.
     *
     * @param string|null $value
     */
    public function token(?string $value): self
    {
        $this->instance->setToken($value);
        return $this;
    }

    /**
     * Sets card field.
     *
     * @param ApplePayRequestCard|null $value
     */
    public function card(?ApplePayRequestCard $value): self
    {
        $this->instance->setCard($value);
        return $this;
    }

    /**
     * Initializes a new Vault Apple Pay Request object.
     */
    public function build(): VaultApplePayRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
