<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\Name;
use PaypalServerSdkLib\Models\PhoneWithType;
use PaypalServerSdkLib\Models\VaultedDigitalWalletShippingDetails;
use PaypalServerSdkLib\Models\VenmoPaymentToken;

/**
 * Builder for model VenmoPaymentToken
 *
 * @see VenmoPaymentToken
 */
class VenmoPaymentTokenBuilder
{
    /**
     * @var VenmoPaymentToken
     */
    private $instance;

    private function __construct(VenmoPaymentToken $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Venmo Payment Token Builder object.
     */
    public static function init(): self
    {
        return new self(new VenmoPaymentToken());
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets usage pattern field.
     *
     * @param string|null $value
     */
    public function usagePattern(?string $value): self
    {
        $this->instance->setUsagePattern($value);
        return $this;
    }

    /**
     * Sets shipping field.
     *
     * @param VaultedDigitalWalletShippingDetails|null $value
     */
    public function shipping(?VaultedDigitalWalletShippingDetails $value): self
    {
        $this->instance->setShipping($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     *
     * @param bool|null $value
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Sets usage type field.
     *
     * @param string|null $value
     */
    public function usageType(?string $value): self
    {
        $this->instance->setUsageType($value);
        return $this;
    }

    /**
     * Sets customer type field.
     *
     * @param string|null $value
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Sets email address field.
     *
     * @param string|null $value
     */
    public function emailAddress(?string $value): self
    {
        $this->instance->setEmailAddress($value);
        return $this;
    }

    /**
     * Sets payer id field.
     *
     * @param string|null $value
     */
    public function payerId(?string $value): self
    {
        $this->instance->setPayerId($value);
        return $this;
    }

    /**
     * Sets name field.
     *
     * @param Name|null $value
     */
    public function name(?Name $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets phone field.
     *
     * @param PhoneWithType|null $value
     */
    public function phone(?PhoneWithType $value): self
    {
        $this->instance->setPhone($value);
        return $this;
    }

    /**
     * Sets address field.
     *
     * @param Address|null $value
     */
    public function address(?Address $value): self
    {
        $this->instance->setAddress($value);
        return $this;
    }

    /**
     * Sets user name field.
     *
     * @param string|null $value
     */
    public function userName(?string $value): self
    {
        $this->instance->setUserName($value);
        return $this;
    }

    /**
     * Initializes a new Venmo Payment Token object.
     */
    public function build(): VenmoPaymentToken
    {
        return CoreHelper::clone($this->instance);
    }
}
