<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Collection of payment tokens saved for a given customer.
 */
class CustomerVaultPaymentTokensResponse implements \JsonSerializable
{
    /**
     * @var int|null
     */
    private $totalItems;

    /**
     * @var int|null
     */
    private $totalPages;

    /**
     * @var VaultResponseCustomer|null
     */
    private $customer;

    /**
     * @var PaymentTokenResponse[]|null
     */
    private $paymentTokens;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Total Items.
     * Total number of items.
     */
    public function getTotalItems(): ?int
    {
        return $this->totalItems;
    }

    /**
     * Sets Total Items.
     * Total number of items.
     *
     * @maps total_items
     */
    public function setTotalItems(?int $totalItems): void
    {
        $this->totalItems = $totalItems;
    }

    /**
     * Returns Total Pages.
     * Total number of pages.
     */
    public function getTotalPages(): ?int
    {
        return $this->totalPages;
    }

    /**
     * Sets Total Pages.
     * Total number of pages.
     *
     * @maps total_pages
     */
    public function setTotalPages(?int $totalPages): void
    {
        $this->totalPages = $totalPages;
    }

    /**
     * Returns Customer.
     * This object defines a customer in your system. Use it to manage customer profiles, save payment
     * methods and contact details.
     */
    public function getCustomer(): ?VaultResponseCustomer
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * This object defines a customer in your system. Use it to manage customer profiles, save payment
     * methods and contact details.
     *
     * @maps customer
     */
    public function setCustomer(?VaultResponseCustomer $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Payment Tokens.
     *
     * @return PaymentTokenResponse[]|null
     */
    public function getPaymentTokens(): ?array
    {
        return $this->paymentTokens;
    }

    /**
     * Sets Payment Tokens.
     *
     * @maps payment_tokens
     *
     * @param PaymentTokenResponse[]|null $paymentTokens
     */
    public function setPaymentTokens(?array $paymentTokens): void
    {
        $this->paymentTokens = $paymentTokens;
    }

    /**
     * Returns Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the CustomerVaultPaymentTokensResponse object to a human-readable string representation.
     *
     * @return string The string representation of the CustomerVaultPaymentTokensResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CustomerVaultPaymentTokensResponse',
            [
                'totalItems' => $this->totalItems,
                'totalPages' => $this->totalPages,
                'customer' => $this->customer,
                'paymentTokens' => $this->paymentTokens,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->totalItems)) {
            $json['total_items']    = $this->totalItems;
        }
        if (isset($this->totalPages)) {
            $json['total_pages']    = $this->totalPages;
        }
        if (isset($this->customer)) {
            $json['customer']       = $this->customer;
        }
        if (isset($this->paymentTokens)) {
            $json['payment_tokens'] = $this->paymentTokens;
        }
        if (isset($this->links)) {
            $json['links']          = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
