<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The regular and trial execution details for a billing cycle.
 */
class CycleExecution implements \JsonSerializable
{
    /**
     * @var string
     */
    private $tenureType;

    /**
     * @var int
     */
    private $sequence;

    /**
     * @var int
     */
    private $cyclesCompleted;

    /**
     * @var int|null
     */
    private $cyclesRemaining;

    /**
     * @var int|null
     */
    private $currentPricingSchemeVersion;

    /**
     * @var int|null
     */
    private $totalCycles;

    /**
     * @param string $tenureType
     * @param int $sequence
     * @param int $cyclesCompleted
     */
    public function __construct(string $tenureType, int $sequence, int $cyclesCompleted)
    {
        $this->tenureType = $tenureType;
        $this->sequence = $sequence;
        $this->cyclesCompleted = $cyclesCompleted;
    }

    /**
     * Returns Tenure Type.
     * The type of the billing cycle.
     */
    public function getTenureType(): string
    {
        return $this->tenureType;
    }

    /**
     * Sets Tenure Type.
     * The type of the billing cycle.
     *
     * @required
     * @maps tenure_type
     */
    public function setTenureType(string $tenureType): void
    {
        $this->tenureType = $tenureType;
    }

    /**
     * Returns Sequence.
     * The order in which to run this cycle among other billing cycles.
     */
    public function getSequence(): int
    {
        return $this->sequence;
    }

    /**
     * Sets Sequence.
     * The order in which to run this cycle among other billing cycles.
     *
     * @required
     * @maps sequence
     */
    public function setSequence(int $sequence): void
    {
        $this->sequence = $sequence;
    }

    /**
     * Returns Cycles Completed.
     * The number of billing cycles that have completed.
     */
    public function getCyclesCompleted(): int
    {
        return $this->cyclesCompleted;
    }

    /**
     * Sets Cycles Completed.
     * The number of billing cycles that have completed.
     *
     * @required
     * @maps cycles_completed
     */
    public function setCyclesCompleted(int $cyclesCompleted): void
    {
        $this->cyclesCompleted = $cyclesCompleted;
    }

    /**
     * Returns Cycles Remaining.
     * For a finite billing cycle, cycles_remaining is the number of remaining cycles. For an infinite
     * billing cycle, cycles_remaining is set as 0.
     */
    public function getCyclesRemaining(): ?int
    {
        return $this->cyclesRemaining;
    }

    /**
     * Sets Cycles Remaining.
     * For a finite billing cycle, cycles_remaining is the number of remaining cycles. For an infinite
     * billing cycle, cycles_remaining is set as 0.
     *
     * @maps cycles_remaining
     */
    public function setCyclesRemaining(?int $cyclesRemaining): void
    {
        $this->cyclesRemaining = $cyclesRemaining;
    }

    /**
     * Returns Current Pricing Scheme Version.
     * The active pricing scheme version for the billing cycle.
     */
    public function getCurrentPricingSchemeVersion(): ?int
    {
        return $this->currentPricingSchemeVersion;
    }

    /**
     * Sets Current Pricing Scheme Version.
     * The active pricing scheme version for the billing cycle.
     *
     * @maps current_pricing_scheme_version
     */
    public function setCurrentPricingSchemeVersion(?int $currentPricingSchemeVersion): void
    {
        $this->currentPricingSchemeVersion = $currentPricingSchemeVersion;
    }

    /**
     * Returns Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     */
    public function getTotalCycles(): ?int
    {
        return $this->totalCycles;
    }

    /**
     * Sets Total Cycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be executed a
     * finite number of times (value between 1 and 999 for total_cycles). Regular billing cycles can be
     * executed infinite times (value of 0 for total_cycles) or a finite number of times (value between 1
     * and 999 for total_cycles).
     *
     * @maps total_cycles
     */
    public function setTotalCycles(?int $totalCycles): void
    {
        $this->totalCycles = $totalCycles;
    }

    /**
     * Converts the CycleExecution object to a human-readable string representation.
     *
     * @return string The string representation of the CycleExecution object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'CycleExecution',
            [
                'tenureType' => $this->tenureType,
                'sequence' => $this->sequence,
                'cyclesCompleted' => $this->cyclesCompleted,
                'cyclesRemaining' => $this->cyclesRemaining,
                'currentPricingSchemeVersion' => $this->currentPricingSchemeVersion,
                'totalCycles' => $this->totalCycles
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['tenure_type']                        = $this->tenureType;
        $json['sequence']                           = $this->sequence;
        $json['cycles_completed']                   = $this->cyclesCompleted;
        if (isset($this->cyclesRemaining)) {
            $json['cycles_remaining']               = $this->cyclesRemaining;
        }
        if (isset($this->currentPricingSchemeVersion)) {
            $json['current_pricing_scheme_version'] = $this->currentPricingSchemeVersion;
        }
        if (isset($this->totalCycles)) {
            $json['total_cycles']                   = $this->totalCycles;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
