<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

/**
 * The declined payment transactions might have payment advice codes. The card networks, like Visa and
 * Mastercard, return payment advice codes.
 */
class PaymentAdviceCode
{
    /**
     * For Mastercard, expired card account upgrade or portfolio sale conversion. Obtain new account
     * information before next billing cycle.
     */
    public const PAYMENTADVICE_01 = '01';

    /**
     * For Mastercard, over credit limit or insufficient funds. Retry the transaction 72 hours later. For
     * Visa, the card holder wants to stop only one specific payment in the recurring payment relationship.
     * The merchant must NOT resubmit the same transaction. The merchant can continue the billing process
     * in the subsequent billing period.
     */
    public const PAYMENTADVICE_02 = '02';

    /**
     * For Mastercard, account closed as fraudulent. Obtain another type of payment from customer due to
     * account being closed or fraud. Possible reason: Account closed as fraudulent. For Visa, the card
     * holder wants to stop all recurring payment transactions for a specific merchant. Stop recurring
     * payment requests.
     */
    public const PAYMENTADVICE_03 = '03';

    /**
     * For Mastercard, token requirements not fulfilled for this token type.
     */
    public const PAYMENTADVICE_04 = '04';

    /**
     * For Mastercard, the card holder has been unsuccessful at canceling recurring payment through
     * merchant. Stop recurring payment requests. For Visa, all recurring payments were canceled for the
     * card number requested. Stop recurring payment requests.
     */
    public const PAYMENTADVICE_21 = '21';

    /**
     * For Mastercard, merchant does not qualify for product code.
     */
    public const PAYMENTADVICE_22 = '22';

    /**
     * For Mastercard, retry after 1 hour.
     */
    public const PAYMENTADVICE_24 = '24';

    /**
     * For Mastercard, retry after 24 hours.
     */
    public const PAYMENTADVICE_25 = '25';

    /**
     * For Mastercard, retry after 2 days.
     */
    public const PAYMENTADVICE_26 = '26';

    /**
     * For Mastercard, retry after 4 days.
     */
    public const PAYMENTADVICE_27 = '27';

    /**
     * For Mastercard, retry after 6 days.
     */
    public const PAYMENTADVICE_28 = '28';

    /**
     * For Mastercard, retry after 8 days.
     */
    public const PAYMENTADVICE_29 = '29';

    /**
     * For Mastercard, retry after 10 days .
     */
    public const PAYMENTADVICE_30 = '30';

    /**
     * For Mastercard, consumer non-reloadable prepaid card.
     */
    public const PAYMENTADVICE_40 = '40';

    /**
     * For Mastercard, consumer multi-use virtual card number.
     */
    public const PAYMENTADVICE_43 = '43';
}
