<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Full representation of a saved payment token.
 */
class PaymentTokenResponse implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var CustomerResponse|null
     */
    private $customer;

    /**
     * @var PaymentTokenResponsePaymentSource|null
     */
    private $paymentSource;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Id.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the merchant's
     * server so the saved payment source can be used for future transactions.
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The PayPal-generated ID for the vaulted payment source. This ID should be stored on the merchant's
     * server so the saved payment source can be used for future transactions.
     *
     * @maps id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Customer.
     * Customer in merchant's or partner's system of records.
     */
    public function getCustomer(): ?CustomerResponse
    {
        return $this->customer;
    }

    /**
     * Sets Customer.
     * Customer in merchant's or partner's system of records.
     *
     * @maps customer
     */
    public function setCustomer(?CustomerResponse $customer): void
    {
        $this->customer = $customer;
    }

    /**
     * Returns Payment Source.
     * The vaulted payment method details.
     */
    public function getPaymentSource(): ?PaymentTokenResponsePaymentSource
    {
        return $this->paymentSource;
    }

    /**
     * Sets Payment Source.
     * The vaulted payment method details.
     *
     * @maps payment_source
     */
    public function setPaymentSource(?PaymentTokenResponsePaymentSource $paymentSource): void
    {
        $this->paymentSource = $paymentSource;
    }

    /**
     * Returns Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of related [HATEOAS links](/api/rest/responses/#hateoas).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the PaymentTokenResponse object to a human-readable string representation.
     *
     * @return string The string representation of the PaymentTokenResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaymentTokenResponse',
            [
                'id' => $this->id,
                'customer' => $this->customer,
                'paymentSource' => $this->paymentSource,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->id)) {
            $json['id']             = $this->id;
        }
        if (isset($this->customer)) {
            $json['customer']       = $this->customer;
        }
        if (isset($this->paymentSource)) {
            $json['payment_source'] = $this->paymentSource;
        }
        if (isset($this->links)) {
            $json['links']          = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
