<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Additional attributes associated with the use of a PayPal Wallet.
 */
class PaypalWalletAttributesResponse implements \JsonSerializable
{
    /**
     * @var PaypalWalletVaultResponse|null
     */
    private $vault;

    /**
     * @var CobrandedCard[]|null
     */
    private $cobrandedCards;

    /**
     * Returns Vault.
     * The details about a saved PayPal Wallet payment source.
     */
    public function getVault(): ?PaypalWalletVaultResponse
    {
        return $this->vault;
    }

    /**
     * Sets Vault.
     * The details about a saved PayPal Wallet payment source.
     *
     * @maps vault
     */
    public function setVault(?PaypalWalletVaultResponse $vault): void
    {
        $this->vault = $vault;
    }

    /**
     * Returns Cobranded Cards.
     * An array of merchant cobranded cards used by buyer to complete an order. This array will be present
     * if a merchant has onboarded their cobranded card with PayPal and provided corresponding label(s).
     *
     * @return CobrandedCard[]|null
     */
    public function getCobrandedCards(): ?array
    {
        return $this->cobrandedCards;
    }

    /**
     * Sets Cobranded Cards.
     * An array of merchant cobranded cards used by buyer to complete an order. This array will be present
     * if a merchant has onboarded their cobranded card with PayPal and provided corresponding label(s).
     *
     * @maps cobranded_cards
     *
     * @param CobrandedCard[]|null $cobrandedCards
     */
    public function setCobrandedCards(?array $cobrandedCards): void
    {
        $this->cobrandedCards = $cobrandedCards;
    }

    /**
     * Converts the PaypalWalletAttributesResponse object to a human-readable string representation.
     *
     * @return string The string representation of the PaypalWalletAttributesResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaypalWalletAttributesResponse',
            ['vault' => $this->vault, 'cobrandedCards' => $this->cobrandedCards]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->vault)) {
            $json['vault']           = $this->vault;
        }
        if (isset($this->cobrandedCards)) {
            $json['cobranded_cards'] = $this->cobrandedCards;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
