<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The create plan request details.
 */
class PlanRequest implements \JsonSerializable
{
    /**
     * @var string
     */
    private $productId;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string|null
     */
    private $status = PlanRequestStatus::ACTIVE;

    /**
     * @var string|null
     */
    private $description;

    /**
     * @var SubscriptionBillingCycle[]
     */
    private $billingCycles;

    /**
     * @var PaymentPreferences
     */
    private $paymentPreferences;

    /**
     * @var MerchantPreferences|null
     */
    private $merchantPreferences;

    /**
     * @var Taxes|null
     */
    private $taxes;

    /**
     * @var bool|null
     */
    private $quantitySupported = false;

    /**
     * @param string $productId
     * @param string $name
     * @param SubscriptionBillingCycle[] $billingCycles
     * @param PaymentPreferences $paymentPreferences
     */
    public function __construct(
        string $productId,
        string $name,
        array $billingCycles,
        PaymentPreferences $paymentPreferences
    ) {
        $this->productId = $productId;
        $this->name = $name;
        $this->billingCycles = $billingCycles;
        $this->paymentPreferences = $paymentPreferences;
    }

    /**
     * Returns Product Id.
     * The ID of the product created through Catalog Products API.
     */
    public function getProductId(): string
    {
        return $this->productId;
    }

    /**
     * Sets Product Id.
     * The ID of the product created through Catalog Products API.
     *
     * @required
     * @maps product_id
     */
    public function setProductId(string $productId): void
    {
        $this->productId = $productId;
    }

    /**
     * Returns Name.
     * The plan name.
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The plan name.
     *
     * @required
     * @maps name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Status.
     * The initial state of the plan. Allowed input values are CREATED and ACTIVE.
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets Status.
     * The initial state of the plan. Allowed input values are CREATED and ACTIVE.
     *
     * @maps status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns Description.
     * The detailed description of the plan.
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * Sets Description.
     * The detailed description of the plan.
     *
     * @maps description
     */
    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    /**
     * Returns Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two trial
     * cycles and only one regular cycle.
     *
     * @return SubscriptionBillingCycle[]
     */
    public function getBillingCycles(): array
    {
        return $this->billingCycles;
    }

    /**
     * Sets Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. A plan can have at most two trial
     * cycles and only one regular cycle.
     *
     * @required
     * @maps billing_cycles
     *
     * @param SubscriptionBillingCycle[] $billingCycles
     */
    public function setBillingCycles(array $billingCycles): void
    {
        $this->billingCycles = $billingCycles;
    }

    /**
     * Returns Payment Preferences.
     * The payment preferences for a subscription.
     */
    public function getPaymentPreferences(): PaymentPreferences
    {
        return $this->paymentPreferences;
    }

    /**
     * Sets Payment Preferences.
     * The payment preferences for a subscription.
     *
     * @required
     * @maps payment_preferences
     */
    public function setPaymentPreferences(PaymentPreferences $paymentPreferences): void
    {
        $this->paymentPreferences = $paymentPreferences;
    }

    /**
     * Returns Merchant Preferences.
     * The merchant preferences for a subscription.
     */
    public function getMerchantPreferences(): ?MerchantPreferences
    {
        return $this->merchantPreferences;
    }

    /**
     * Sets Merchant Preferences.
     * The merchant preferences for a subscription.
     *
     * @maps merchant_preferences
     */
    public function setMerchantPreferences(?MerchantPreferences $merchantPreferences): void
    {
        $this->merchantPreferences = $merchantPreferences;
    }

    /**
     * Returns Taxes.
     * The tax details.
     */
    public function getTaxes(): ?Taxes
    {
        return $this->taxes;
    }

    /**
     * Sets Taxes.
     * The tax details.
     *
     * @maps taxes
     */
    public function setTaxes(?Taxes $taxes): void
    {
        $this->taxes = $taxes;
    }

    /**
     * Returns Quantity Supported.
     * Indicates whether you can subscribe to this plan by providing a quantity for the goods or service.
     */
    public function getQuantitySupported(): ?bool
    {
        return $this->quantitySupported;
    }

    /**
     * Sets Quantity Supported.
     * Indicates whether you can subscribe to this plan by providing a quantity for the goods or service.
     *
     * @maps quantity_supported
     */
    public function setQuantitySupported(?bool $quantitySupported): void
    {
        $this->quantitySupported = $quantitySupported;
    }

    /**
     * Converts the PlanRequest object to a human-readable string representation.
     *
     * @return string The string representation of the PlanRequest object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PlanRequest',
            [
                'productId' => $this->productId,
                'name' => $this->name,
                'status' => $this->status,
                'description' => $this->description,
                'billingCycles' => $this->billingCycles,
                'paymentPreferences' => $this->paymentPreferences,
                'merchantPreferences' => $this->merchantPreferences,
                'taxes' => $this->taxes,
                'quantitySupported' => $this->quantitySupported
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['product_id']               = $this->productId;
        $json['name']                     = $this->name;
        if (isset($this->status)) {
            $json['status']               = $this->status;
        }
        if (isset($this->description)) {
            $json['description']          = $this->description;
        }
        $json['billing_cycles']           = $this->billingCycles;
        $json['payment_preferences']      = $this->paymentPreferences;
        if (isset($this->merchantPreferences)) {
            $json['merchant_preferences'] = $this->merchantPreferences;
        }
        if (isset($this->taxes)) {
            $json['taxes']                = $this->taxes;
        }
        if (isset($this->quantitySupported)) {
            $json['quantity_supported']   = $this->quantitySupported;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
