<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The store information.
 */
class StoreInformation implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $storeId;

    /**
     * @var string|null
     */
    private $terminalId;

    /**
     * Returns Store Id.
     * The ID of a store for a merchant in the system of record.
     */
    public function getStoreId(): ?string
    {
        return $this->storeId;
    }

    /**
     * Sets Store Id.
     * The ID of a store for a merchant in the system of record.
     *
     * @maps store_id
     */
    public function setStoreId(?string $storeId): void
    {
        $this->storeId = $storeId;
    }

    /**
     * Returns Terminal Id.
     * The terminal ID for the checkout stand in a merchant store.
     */
    public function getTerminalId(): ?string
    {
        return $this->terminalId;
    }

    /**
     * Sets Terminal Id.
     * The terminal ID for the checkout stand in a merchant store.
     *
     * @maps terminal_id
     */
    public function setTerminalId(?string $terminalId): void
    {
        $this->terminalId = $terminalId;
    }

    /**
     * Converts the StoreInformation object to a human-readable string representation.
     *
     * @return string The string representation of the StoreInformation object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'StoreInformation',
            ['storeId' => $this->storeId, 'terminalId' => $this->terminalId]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->storeId)) {
            $json['store_id']    = $this->storeId;
        }
        if (isset($this->terminalId)) {
            $json['terminal_id'] = $this->terminalId;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
