<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The subscription details.
 */
class Subscription implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var string|null
     */
    private $planId;

    /**
     * @var string|null
     */
    private $startTime;

    /**
     * @var string|null
     */
    private $quantity;

    /**
     * @var Money|null
     */
    private $shippingAmount;

    /**
     * @var Subscriber|null
     */
    private $subscriber;

    /**
     * @var SubscriptionBillingInformation|null
     */
    private $billingInfo;

    /**
     * @var string|null
     */
    private $createTime;

    /**
     * @var string|null
     */
    private $updateTime;

    /**
     * @var string|null
     */
    private $customId;

    /**
     * @var bool|null
     */
    private $planOverridden;

    /**
     * @var PlanDetails|null
     */
    private $plan;

    /**
     * @var LinkDescription[]|null
     */
    private $links;

    /**
     * Returns Id.
     * The PayPal-generated ID for the subscription.
     */
    public function getId(): ?string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The PayPal-generated ID for the subscription.
     *
     * @maps id
     */
    public function setId(?string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Plan Id.
     * The ID of the plan.
     */
    public function getPlanId(): ?string
    {
        return $this->planId;
    }

    /**
     * Sets Plan Id.
     * The ID of the plan.
     *
     * @maps plan_id
     */
    public function setPlanId(?string $planId): void
    {
        $this->planId = $planId;
    }

    /**
     * Returns Start Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getStartTime(): ?string
    {
        return $this->startTime;
    }

    /**
     * Sets Start Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps start_time
     */
    public function setStartTime(?string $startTime): void
    {
        $this->startTime = $startTime;
    }

    /**
     * Returns Quantity.
     * The quantity of the product in the subscription.
     */
    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    /**
     * Sets Quantity.
     * The quantity of the product in the subscription.
     *
     * @maps quantity
     */
    public function setQuantity(?string $quantity): void
    {
        $this->quantity = $quantity;
    }

    /**
     * Returns Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     */
    public function getShippingAmount(): ?Money
    {
        return $this->shippingAmount;
    }

    /**
     * Sets Shipping Amount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     *
     * @maps shipping_amount
     */
    public function setShippingAmount(?Money $shippingAmount): void
    {
        $this->shippingAmount = $shippingAmount;
    }

    /**
     * Returns Subscriber.
     * The subscriber response information.
     */
    public function getSubscriber(): ?Subscriber
    {
        return $this->subscriber;
    }

    /**
     * Sets Subscriber.
     * The subscriber response information.
     *
     * @maps subscriber
     */
    public function setSubscriber(?Subscriber $subscriber): void
    {
        $this->subscriber = $subscriber;
    }

    /**
     * Returns Billing Info.
     * The billing details for the subscription. If the subscription was or is active, these fields are
     * populated.
     */
    public function getBillingInfo(): ?SubscriptionBillingInformation
    {
        return $this->billingInfo;
    }

    /**
     * Sets Billing Info.
     * The billing details for the subscription. If the subscription was or is active, these fields are
     * populated.
     *
     * @maps billing_info
     */
    public function setBillingInfo(?SubscriptionBillingInformation $billingInfo): void
    {
        $this->billingInfo = $billingInfo;
    }

    /**
     * Returns Create Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getCreateTime(): ?string
    {
        return $this->createTime;
    }

    /**
     * Sets Create Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps create_time
     */
    public function setCreateTime(?string $createTime): void
    {
        $this->createTime = $createTime;
    }

    /**
     * Returns Update Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getUpdateTime(): ?string
    {
        return $this->updateTime;
    }

    /**
     * Sets Update Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @maps update_time
     */
    public function setUpdateTime(?string $updateTime): void
    {
        $this->updateTime = $updateTime;
    }

    /**
     * Returns Custom Id.
     * The custom id for the subscription. Can be invoice id.
     */
    public function getCustomId(): ?string
    {
        return $this->customId;
    }

    /**
     * Sets Custom Id.
     * The custom id for the subscription. Can be invoice id.
     *
     * @maps custom_id
     */
    public function setCustomId(?string $customId): void
    {
        $this->customId = $customId;
    }

    /**
     * Returns Plan Overridden.
     * Indicates whether the subscription has overridden any plan attributes.
     */
    public function getPlanOverridden(): ?bool
    {
        return $this->planOverridden;
    }

    /**
     * Sets Plan Overridden.
     * Indicates whether the subscription has overridden any plan attributes.
     *
     * @maps plan_overridden
     */
    public function setPlanOverridden(?bool $planOverridden): void
    {
        $this->planOverridden = $planOverridden;
    }

    /**
     * Returns Plan.
     * The plan details.
     */
    public function getPlan(): ?PlanDetails
    {
        return $this->plan;
    }

    /**
     * Sets Plan.
     * The plan details.
     *
     * @maps plan
     */
    public function setPlan(?PlanDetails $plan): void
    {
        $this->plan = $plan;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @return LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @maps links
     *
     * @param LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Converts the Subscription object to a human-readable string representation.
     *
     * @return string The string representation of the Subscription object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'Subscription',
            [
                'id' => $this->id,
                'planId' => $this->planId,
                'startTime' => $this->startTime,
                'quantity' => $this->quantity,
                'shippingAmount' => $this->shippingAmount,
                'subscriber' => $this->subscriber,
                'billingInfo' => $this->billingInfo,
                'createTime' => $this->createTime,
                'updateTime' => $this->updateTime,
                'customId' => $this->customId,
                'planOverridden' => $this->planOverridden,
                'plan' => $this->plan,
                'links' => $this->links
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->id)) {
            $json['id']              = $this->id;
        }
        if (isset($this->planId)) {
            $json['plan_id']         = $this->planId;
        }
        if (isset($this->startTime)) {
            $json['start_time']      = $this->startTime;
        }
        if (isset($this->quantity)) {
            $json['quantity']        = $this->quantity;
        }
        if (isset($this->shippingAmount)) {
            $json['shipping_amount'] = $this->shippingAmount;
        }
        if (isset($this->subscriber)) {
            $json['subscriber']      = $this->subscriber;
        }
        if (isset($this->billingInfo)) {
            $json['billing_info']    = $this->billingInfo;
        }
        if (isset($this->createTime)) {
            $json['create_time']     = $this->createTime;
        }
        if (isset($this->updateTime)) {
            $json['update_time']     = $this->updateTime;
        }
        if (isset($this->customId)) {
            $json['custom_id']       = $this->customId;
        }
        if (isset($this->planOverridden)) {
            $json['plan_overridden'] = $this->planOverridden;
        }
        if (isset($this->plan)) {
            $json['plan']            = $this->plan;
        }
        if (isset($this->links)) {
            $json['links']           = $this->links;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
