<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * The transaction details.
 */
class SubscriptionTransactionDetails implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string
     */
    private $id;

    /**
     * @var SubscriptionAmountWithBreakdown
     */
    private $amountWithBreakdown;

    /**
     * @var SubscriptionPayerName|null
     */
    private $payerName;

    /**
     * @var string|null
     */
    private $payerEmail;

    /**
     * @var string
     */
    private $time;

    /**
     * @param string $id
     * @param SubscriptionAmountWithBreakdown $amountWithBreakdown
     * @param string $time
     */
    public function __construct(string $id, SubscriptionAmountWithBreakdown $amountWithBreakdown, string $time)
    {
        $this->id = $id;
        $this->amountWithBreakdown = $amountWithBreakdown;
        $this->time = $time;
    }

    /**
     * Returns Status.
     * The status of the captured payment.
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets Status.
     * The status of the captured payment.
     *
     * @maps status
     */
    public function setStatus(?string $status): void
    {
        $this->status = $status;
    }

    /**
     * Returns Id.
     * The PayPal-generated transaction ID.
     */
    public function getId(): string
    {
        return $this->id;
    }

    /**
     * Sets Id.
     * The PayPal-generated transaction ID.
     *
     * @required
     * @maps id
     */
    public function setId(string $id): void
    {
        $this->id = $id;
    }

    /**
     * Returns Amount With Breakdown.
     * The breakdown details for the amount. Includes the gross, tax, fee, and shipping amounts.
     */
    public function getAmountWithBreakdown(): SubscriptionAmountWithBreakdown
    {
        return $this->amountWithBreakdown;
    }

    /**
     * Sets Amount With Breakdown.
     * The breakdown details for the amount. Includes the gross, tax, fee, and shipping amounts.
     *
     * @required
     * @maps amount_with_breakdown
     */
    public function setAmountWithBreakdown(SubscriptionAmountWithBreakdown $amountWithBreakdown): void
    {
        $this->amountWithBreakdown = $amountWithBreakdown;
    }

    /**
     * Returns Payer Name.
     * The name of the party.
     */
    public function getPayerName(): ?SubscriptionPayerName
    {
        return $this->payerName;
    }

    /**
     * Sets Payer Name.
     * The name of the party.
     *
     * @maps payer_name
     */
    public function setPayerName(?SubscriptionPayerName $payerName): void
    {
        $this->payerName = $payerName;
    }

    /**
     * Returns Payer Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     */
    public function getPayerEmail(): ?string
    {
        return $this->payerEmail;
    }

    /**
     * Sets Payer Email.
     * The internationalized email address. Note: Up to 64 characters are allowed before and 255 characters
     * are allowed after the @ sign. However, the generally accepted maximum length for an email address is
     * 254 characters. The pattern verifies that an unquoted @ sign exists.
     *
     * @maps payer_email
     */
    public function setPayerEmail(?string $payerEmail): void
    {
        $this->payerEmail = $payerEmail;
    }

    /**
     * Returns Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     */
    public function getTime(): string
    {
        return $this->time;
    }

    /**
     * Sets Time.
     * The date and time, in [Internet date and time format](https://tools.ietf.org/html/rfc3339#section-5.
     * 6). Seconds are required while fractional seconds are optional. Note: The regular expression
     * provides guidance but does not reject all invalid dates.
     *
     * @required
     * @maps time
     */
    public function setTime(string $time): void
    {
        $this->time = $time;
    }

    /**
     * Converts the SubscriptionTransactionDetails object to a human-readable string representation.
     *
     * @return string The string representation of the SubscriptionTransactionDetails object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SubscriptionTransactionDetails',
            [
                'status' => $this->status,
                'id' => $this->id,
                'amountWithBreakdown' => $this->amountWithBreakdown,
                'payerName' => $this->payerName,
                'payerEmail' => $this->payerEmail,
                'time' => $this->time
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->status)) {
            $json['status']            = $this->status;
        }
        $json['id']                    = $this->id;
        $json['amount_with_breakdown'] = $this->amountWithBreakdown;
        if (isset($this->payerName)) {
            $json['payer_name']        = $this->payerName;
        }
        if (isset($this->payerEmail)) {
            $json['payer_email']       = $this->payerEmail;
        }
        $json['time']                  = $this->time;

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
