<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Results of 3D Secure Authentication.
 */
class ThreeDSecureCardAuthenticationResponse implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $authenticationStatus;

    /**
     * @var string|null
     */
    private $enrollmentStatus;

    /**
     * @var string|null
     */
    private $authenticationId;

    /**
     * Returns Authentication Status.
     * Transactions status result identifier. The outcome of the issuer's authentication.
     */
    public function getAuthenticationStatus(): ?string
    {
        return $this->authenticationStatus;
    }

    /**
     * Sets Authentication Status.
     * Transactions status result identifier. The outcome of the issuer's authentication.
     *
     * @maps authentication_status
     */
    public function setAuthenticationStatus(?string $authenticationStatus): void
    {
        $this->authenticationStatus = $authenticationStatus;
    }

    /**
     * Returns Enrollment Status.
     * Status of Authentication eligibility.
     */
    public function getEnrollmentStatus(): ?string
    {
        return $this->enrollmentStatus;
    }

    /**
     * Sets Enrollment Status.
     * Status of Authentication eligibility.
     *
     * @maps enrollment_status
     */
    public function setEnrollmentStatus(?string $enrollmentStatus): void
    {
        $this->enrollmentStatus = $enrollmentStatus;
    }

    /**
     * Returns Authentication Id.
     * The externally received 3ds authentication id, to be returned in card detokenization response.
     */
    public function getAuthenticationId(): ?string
    {
        return $this->authenticationId;
    }

    /**
     * Sets Authentication Id.
     * The externally received 3ds authentication id, to be returned in card detokenization response.
     *
     * @maps authentication_id
     */
    public function setAuthenticationId(?string $authenticationId): void
    {
        $this->authenticationId = $authenticationId;
    }

    /**
     * Converts the ThreeDSecureCardAuthenticationResponse object to a human-readable string representation.
     *
     * @return string The string representation of the ThreeDSecureCardAuthenticationResponse object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'ThreeDSecureCardAuthenticationResponse',
            [
                'authenticationStatus' => $this->authenticationStatus,
                'enrollmentStatus' => $this->enrollmentStatus,
                'authenticationId' => $this->authenticationId
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->authenticationStatus)) {
            $json['authentication_status'] = $this->authenticationStatus;
        }
        if (isset($this->enrollmentStatus)) {
            $json['enrollment_status']     = $this->enrollmentStatus;
        }
        if (isset($this->authenticationId)) {
            $json['authentication_id']     = $this->authenticationId;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
