<?php
require_once 'config/database.php';
require_once 'config/auth.php';
require_once 'includes/functions.php';

$slug = $_GET['slug'] ?? '';
$post = getPostBySlug($slug);

if (!$post) {
    header('HTTP/1.0 404 Not Found');
    $page_title = 'Post Not Found';
    include 'includes/header.php';
    ?>
    <div class="container">
        <div class="error-message">
            <h1>Post Not Found</h1>
            <p>The post you are looking for does not exist.</p>
            <a href="<?php echo BASE_URL; ?>home" class="btn btn-primary">Back to Home</a>
        </div>
    </div>
    <?php
    include 'includes/footer.php';
    exit;
}

$page_title = $post['title'];
include 'includes/header.php';
?>

<div class="post-single">
    <div class="container">
        <div class="post-header">
            <h1 class="post-title"><?php echo htmlspecialchars($post['title']); ?></h1>
        </div>

        <div class="post-meta">
            <span class="post-author">By <?php echo htmlspecialchars($post['author_name']); ?></span>
            <span class="post-date"><?php echo formatDate($post['created_at']); ?></span>
            <?php if ($post['category_name']): ?>
                <span class="post-category"><?php echo htmlspecialchars($post['category_name']); ?></span>
            <?php endif; ?>
        </div>

        <div class="post-content">
            <?php echo $post['content']; ?>
        </div>

        <div class="post-footer">
            <div class="post-share">
                <span>Share this post:</span>
                <a href="https://twitter.com/intent/tweet?text=<?php echo urlencode($post['title']); ?>&url=<?php echo urlencode(BASE_URL . 'post.php?slug=' . $post['slug']); ?>" class="share-link" target="_blank">
                    <i class="fab fa-twitter"></i> Twitter
                </a>
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(BASE_URL . 'post.php?slug=' . $post['slug']); ?>" class="share-link" target="_blank">
                    <i class="fab fa-facebook"></i> Facebook
                </a>
                <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode(BASE_URL . 'post.php?slug=' . $post['slug']); ?>" class="share-link" target="_blank">
                    <i class="fab fa-linkedin"></i> LinkedIn
                </a>
            </div>
        </div>

        <div class="post-navigation">
            <a href="javascript:history.back()" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back
            </a>
            <a href="<?php echo BASE_URL; ?>home" class="btn btn-primary">
                <i class="fas fa-home"></i> Home
            </a>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>