<?php
// Common sidebar navigation for instructor panel
// Set $active_link in the including page, e.g. $active_link = 'dashboard';

// Get site name from config
$lms_config = require __DIR__ . '/../../config/lms.php';
$site_name = $lms_config['lms']['site_name'];
?>
<!-- Sidebar Navigation (Desktop View) -->
<aside class="hidden lg:block w-64 bg-white border-r border-accent-subtle p-6 shadow-sm sticky top-16 h-screen">
    <div class="flex flex-col h-full">
        <!-- Logo/Title -->
        <div class="text-xl font-extrabold text-primary-blue mb-10 tracking-wider">
            <?php echo htmlspecialchars($site_name); ?>
        </div>

        <!-- Navigation Links -->
        <nav class="space-y-2 flex-grow">
            <a href="<?php echo BASE_URL; ?>instructor/dashboard.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'dashboard' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">🏠</span>
                <span>Dashboard</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/courses/index.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'courses' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📚</span>
                <span>My Courses</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/courses/new.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'new_course' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">➕</span>
                <span>Create Course</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/questions/index.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'questions' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">❓</span>
                <span>Question Bank</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/exams/index.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'exams' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📝</span>
                <span>Exams & Quizzes</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/exams/new.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'new_exam' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📋</span>
                <span>Create Exam</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/students.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'students' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">👥</span>
                <span>My Students</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/resources.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'resources' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📖</span>
                <span>Resources</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/assignments.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'assignments' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📋</span>
                <span>Assignments</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/analytics.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'analytics' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📊</span>
                <span>Analytics</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/student_progress.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'student_progress' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">📈</span>
                <span>Student Progress</span>
            </a>
            <a href="<?php echo BASE_URL; ?>instructor/grading/index.php" class="flex items-center space-x-3 p-3 rounded-lg <?php echo $active_link === 'grading' ? 'bg-primary-blue text-white font-semibold shadow-md' : 'text-text-dark hover:bg-accent-subtle'; ?> transition duration-150">
                <span class="w-5 h-5">🏆</span>
                <span>Grades</span>
            </a>
            <a href="<?php echo BASE_URL; ?>logout.php" class="flex items-center space-x-3 p-3 rounded-lg text-text-dark hover:bg-accent-subtle transition duration-150">
                <span class="w-5 h-5">🚪</span>
                <span>Logout</span>
            </a>
        </nav>

        <!-- Footer/User Info (Bottom of Sidebar) -->
        <div class="mt-8 pt-4 border-t border-accent-subtle">
            <p class="text-xs text-gray-500 mb-2">Authenticated User:</p>
            <p class="text-xs text-gray-700 truncate font-mono bg-accent-subtle p-1 rounded"><?php echo htmlspecialchars($user['username'] ?? 'Instructor'); ?></p>
        </div>
    </div>
</aside>