<?php
require_once 'config/database.php';

echo "=== SAMPLE EXAMS FUNCTIONALITY TEST ===\n\n";

try {
    $db = getDB();

    // Test 1: Check published exams
    echo "1. Checking published exams:\n";
    $stmt = $db->query("SELECT id, title, exam_type, total_points, passing_score FROM exams WHERE status = 'published' ORDER BY id");
    $exams = $stmt->fetchAll();

    foreach ($exams as $exam) {
        echo "   ✓ {$exam['title']} (ID: {$exam['id']}, Type: {$exam['exam_type']}, Points: {$exam['total_points']}, Pass: {$exam['passing_score']}%)\n";
    }
    echo "\n";

    // Test 2: Check exam questions
    echo "2. Checking exam questions:\n";
    foreach ($exams as $exam) {
        $stmt = $db->prepare("
            SELECT COUNT(*) as q_count,
                   SUM(eq.points) as total_points,
                   GROUP_CONCAT(DISTINCT q.question_type) as types
            FROM exam_questions eq
            JOIN questions q ON eq.question_id = q.id
            WHERE eq.exam_id = ?
        ");
        $stmt->execute([$exam['id']]);
        $questionData = $stmt->fetch();

        echo "   ✓ {$exam['title']}: {$questionData['q_count']} questions, {$questionData['total_points']} points, Types: {$questionData['types']}\n";
    }
    echo "\n";

    // Test 3: Check question options
    echo "3. Checking question options:\n";
    foreach ($exams as $exam) {
        $stmt = $db->prepare("
            SELECT q.title, q.question_type, COUNT(qo.id) as option_count
            FROM exam_questions eq
            JOIN questions q ON eq.question_id = q.id
            LEFT JOIN question_options qo ON q.id = qo.question_id
            WHERE eq.exam_id = ?
            GROUP BY q.id, q.title, q.question_type
        ");
        $stmt->execute([$exam['id']]);
        $questions = $stmt->fetchAll();

        foreach ($questions as $question) {
            $optionInfo = $question['option_count'] > 0 ? "({$question['option_count']} options)" : "(text input)";
            echo "   ✓ {$question['title']}: {$question['question_type']} $optionInfo\n";
        }
    }
    echo "\n";

    // Test 4: Check student access
    echo "4. Checking student access:\n";
    $stmt = $db->query("SELECT id, username, email FROM users WHERE role = 'student' LIMIT 3");
    $students = $stmt->fetchAll();

    foreach ($students as $student) {
        echo "   ✓ Student: {$student['username']} ({$student['email']})\n";

        // Check if student can access exams
        foreach ($exams as $exam) {
            $stmt = $db->prepare("
                SELECT COUNT(*) as attempt_count
                FROM exam_attempts
                WHERE exam_id = ? AND student_id = ?
            ");
            $stmt->execute([$exam['id'], $student['id']]);
            $attempts = $stmt->fetch()['attempt_count'];

            echo "     - {$exam['title']}: {$attempts} previous attempts\n";
        }
    }
    echo "\n";

    // Test 5: Check instructor access
    echo "5. Checking instructor access:\n";
    $stmt = $db->query("SELECT id, username FROM users WHERE role = 'instructor' LIMIT 2");
    $instructors = $stmt->fetchAll();

    foreach ($instructors as $instructor) {
        echo "   ✓ Instructor: {$instructor['username']}\n";

        $stmt = $db->prepare("SELECT COUNT(*) as exam_count FROM exams WHERE instructor_id = ?");
        $stmt->execute([$instructor['id']]);
        $examCount = $stmt->fetch()['exam_count'];

        echo "     - Created {$examCount} exams\n";
    }
    echo "\n";

    echo "=== ALL TESTS PASSED ===\n";
    echo "Sample exams are fully functional and ready for use!\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>