
# Shipment Carrier

The carrier for the shipment. Some carriers have a global version as well as local subsidiaries. The subsidiaries are repeated over many countries and might also have an entry in the global list. Choose the carrier for your country. If the carrier is not available for your country, choose the global version of the carrier. If your carrier name is not in the list, set `carrier` to `OTHER` and set carrier name in `carrier_name_other`. For allowed values, see Carriers.

## Enumeration

`ShipmentCarrier`

## Fields

| Name | Description |
|  --- | --- |
| `DPD_RU` | DPD Russia. |
| `BG_BULGARIAN_POST` | Bulgarian Posts. |
| `KR_KOREA_POST` | Koreapost (www.koreapost.go.kr). |
| `ZA_COURIERIT` | Courier IT. |
| `FR_EXAPAQ` | DPD France (formerly exapaq). |
| `ARE_EMIRATES_POST` | Emirates Post. |
| `GAC` | GAC. |
| `GEIS` | Geis CZ. |
| `SF_EX` | SF Express. |
| `PAGO` | Pago Logistics. |
| `MYHERMES` | MyHermes UK. |
| `DIAMOND_EUROGISTICS` | Diamond Eurogistics Limited. |
| `CORPORATECOURIERS_WEBHOOK` | Corporate Couriers. |
| `BOND` | Bond courier. |
| `OMNIPARCEL` | Omni Parcel. |
| `SK_POSTA` | Slovenska pošta. |
| `PUROLATOR` | purolator. |
| `FETCHR_WEBHOOK` | Mena 360 (Fetchr). |
| `THEDELIVERYGROUP` | TDG – The Delivery Group. |
| `CELLO_SQUARE` | Cello Square. |
| `TARRIVE` | TONDA GLOBAL. |
| `COLLIVERY` | MDS Collivery Pty (Ltd). |
| `MAINFREIGHT` | Mainfreight. |
| `IND_FIRSTFLIGHT` | First Flight Couriers. |
| `ACSWORLDWIDE` | ACS Worldwide Express. |
| `AMSTAN` | Amstan Logistics. |
| `OKAYPARCEL` | OkayParcel. |
| `ENVIALIA_REFERENCE` | Envialia Reference. |
| `SEUR_ES` | Seur Spain. |
| `CONTINENTAL` | Continental. |
| `FDSEXPRESS` | FDSEXPRESS. |
| `AMAZON_FBA_SWISHIP` | Swiship UK. |
| `WYNGS` | Wyngs. |
| `DHL_ACTIVE_TRACING` | DHL Active Tracing. |
| `ZYLLEM` | Zyllem. |
| `RUSTON` | Ruston. |
| `XPOST` | Xpost.ph. |
| `CORREOS_ES` | correos Express (www.correos.es). |
| `DHL_FR` | DHL France (www.dhl.com). |
| `PAN_ASIA` | Pan-Asia International. |
| `BRT_IT` | BRT couriers Italy (www.brt.it). |
| `SRE_KOREA` | SRE Korea (www.srekorea.co.kr). |
| `SPEEDEE` | Spee-Dee Delivery. |
| `TNT_UK` | TNT UK Limited (www.tnt.com). |
| `VENIPAK` | Venipak. |
| `SHREENANDANCOURIER` | SHREE NANDAN COURIER. |
| `CROSHOT` | Croshot. |
| `NIPOST_NG` | NIpost (www.nipost.gov.ng). |
| `EPST_GLBL` | ePost Global. |
| `NEWGISTICS` | Newgistics. |
| `POST_SLOVENIA` | Post of Slovenia. |
| `JERSEY_POST` | Jersey Post. |
| `BOMBINOEXP` | Bombino Express Pvt. |
| `WMG` | WMG Delivery. |
| `XQ_EXPRESS` | XQ Express. |
| `FURDECO` | Furdeco. |
| `LHT_EXPRESS` | LHT Express. |
| `SOUTH_AFRICAN_POST_OFFICE` | South African Post Office. |
| `SPOTON` | SPOTON Logistics Pvt Ltd. |
| `DIMERCO` | Dimerco Express Group. |
| `CYPRUS_POST_CYP` | cyprus post. |
| `ABCUSTOM` | AB Custom Group. |
| `IND_DELIVREE` | deliverE. |
| `CN_BESTEXPRESS` | Best Express. |
| `DX_SFTP` | DX (SFTP). |
| `PICKUPP_MYS` | PICK UPP. |
| `FMX` | FMX. |
| `HELLMANN` | Hellmann Worldwide Logistics. |
| `SHIP_IT_ASIA` | Ship It Asia. |
| `KERRY_ECOMMERCE` | Kerry eCommerce. |
| `FRETERAPIDO` | Frete Rapido. |
| `PITNEY_BOWES` | Pitney Bowes. |
| `XPRESSEN_DK` | Xpressen courier. |
| `SEUR_SP_API` | Spanish Seur API. |
| `DELIVERYONTIME` | DELIVERYONTIME LOGISTICS PVT LTD. |
| `JINSUNG` | JINSUNG TRADING. |
| `TRANS_KARGO` | Trans Kargo Internasional. |
| `SWISHIP_DE` | Swiship DE. |
| `IVOY_WEBHOOK` | Ivoy courier. |
| `AIRMEE_WEBHOOK` | Airmee couriers. |
| `DHL_BENELUX` | dhl benelux. |
| `FIRSTMILE` | FirstMile. |
| `FASTWAY_IR` | Fastway Ireland. |
| `HH_EXP` | Hua Han Logistics. |
| `MYS_MYPOST_ONLINE` | Mypostonline. |
| `TNT_NL` | THT Netherland. |
| `TIPSA` | TIPSA courier. |
| `TAQBIN_MY` | TAQBIN Malaysia. |
| `KGMHUB` | KGM Hub. |
| `INTEXPRESS` | Internet Express. |
| `OVERSE_EXP` | Overseas Express. |
| `ONECLICK` | One click delivery services. |
| `ROADRUNNER_FREIGHT` | Roadbull Logistics. |
| `GLS_CROTIA` | GLS Croatia. |
| `MRW_FTP` | MRW courier. |
| `BLUEX` | Blue Express. |
| `DYLT` | Daylight Transport. |
| `DPD_IR` | DPD Ireland. |
| `SIN_GLBL` | Sin Global Express. |
| `TUFFNELLS_REFERENCE` | Tuffnells Parcels Express- Reference. |
| `CJPACKET` | CJ Packet. |
| `MILKMAN` | Milkman courier. |
| `ASIGNA` | ASIGNA courier. |
| `ONEWORLDEXPRESS` | One World Express. |
| `ROYAL_MAIL` | RoyalShipments. |
| `VIA_EXPRESS` | Viaxpress. |
| `TIGFREIGHT` | TIG Freight. |
| `ZTO_EXPRESS` | ZTO Express. |
| `TWO_GO` | 2GO Courier. |
| `IML` | IML courier. |
| `INTEL_VALLEY` | Intel-Valley Supply chain (ShenZhen) Co. Ltd. |
| `EFS` | EFS (E-commerce Fulfillment Service). |
| `UK_UK_MAIL` | UK mail (ukmail.com). |
| `RAM` | RAM courier. |
| `ALLIEDEXPRESS` | Allied Express. |
| `APC_OVERNIGHT` | APC overnight (apc-overnight.com). |
| `SHIPPIT` | Shippit. |
| `TFM` | TFM Xpress. |
| `M_XPRESS` | M Xpress Sdn Bhd. |
| `HDB_BOX` | Haidaibao (BOX). |
| `CLEVY_LINKS` | Clevy Links. |
| `IBEONE` | Beone Logistics. |
| `FIEGE_NL` | Fiege Netherlands. |
| `KWE_GLOBAL` | KWE Global. |
| `CTC_EXPRESS` | CTC Express. |
| `AMAZON` | Amazon Shipping. |
| `MORE_LINK` | Morelink. |
| `JX` | JX courier. |
| `EASY_MAIL` | Easy Mail. |
| `ADUIEPYLE` | A Duie Pyle. |
| `GB_PANTHER` | Panther. |
| `EXPRESSSALE` | Expresssale. |
| `SG_DETRACK` | Detrack. |
| `TRUNKRS_WEBHOOK` | Trunkrs courier. |
| `MATDESPATCH` | Matdespatch. |
| `DICOM` | GLS Logistic Systems Canada Ltd./Dicom. |
| `MBW` | MBW Courier Inc.. |
| `KHM_CAMBODIA_POST` | Cambodia Post. |
| `SINOTRANS` | Sinotrans. |
| `BRT_IT_PARCELID` | BRT Bartolini(Parcel ID). |
| `DHL_SUPPLY_CHAIN` | DHL Supply Chain APAC. |
| `DHL_PL` | DHL Poland. |
| `TOPYOU` | TopYou. |
| `PALEXPRESS` | PAL Express Limited. |
| `DHL_SG` | dhl Singapore. |
| `CN_WEDO` | WeDo Logistics. |
| `FULFILLME` | Fulfillme. |
| `DPD_DELISTRACK` | DPD delistrack. |
| `UPS_REFERENCE` | UPS Reference. |
| `CARIBOU` | Caribou. |
| `LOCUS_WEBHOOK` | Locus courier. |
| `DSV` | DSV courier. |
| `P2P_TRC` | P2P TrakPak. |
| `DIRECTPARCELS` | Direct Parcels. |
| `NOVA_POSHTA_INT` | Nova Poshta (International). |
| `FEDEX_POLAND` | FedEx® Poland Domestic. |
| `CN_JCEX` | JCEX courier. |
| `FAR_INTERNATIONAL` | FAR international. |
| `IDEXPRESS` | IDEX courier. |
| `GANGBAO` | GANGBAO Supplychain. |
| `NEWAY` | Neway Transport. |
| `POSTNL_INT_3_S` | PostNL International. |
| `RPX_ID` | RPX Indonesia. |
| `DESIGNERTRANSPORT_WEBHOOK` | Designer Transport. |
| `GLS_SLOVEN` | GLS Slovenia. |
| `PARCELLED_IN` | Parcelled.in. |
| `GSI_EXPRESS` | GSI EXPRESS. |
| `CON_WAY` | Con-way Freight. |
| `BROUWER_TRANSPORT` | Brouwer Transport en Logistiek. |
| `CPEX` | Captain Express International. |
| `ISRAEL_POST` | Israel Post. |
| `DTDC_IN` | DTDC India. |
| `PTT_POST` | PTT Post. |
| `XDE_WEBHOOK` | Ximex Delivery Express. |
| `TOLOS` | Tolos courier. |
| `GIAO_HANG` | Giao hàng nhanh. |
| `GEODIS_ESPACE` | Geodis E-space. |
| `MAGYAR_HU` | Magyar Post. |
| `DOORDASH_WEBHOOK` | DoorDash. |
| `TIKI_ID` | Tiki shipment. |
| `CJ_HK_INTERNATIONAL` | CJ Logistics International(Hong Kong). |
| `STAR_TRACK_EXPRESS` | Star Track Express. |
| `HELTHJEM` | Helthjem. |
| `SFB2C` | SF International. |
| `FREIGHTQUOTE` | Freightquote by C.H. Robinson. |
| `LANDMARK_GLOBAL_REFERENCE` | Landmark Global Reference. |
| `PARCEL2GO` | Parcel2Go. |
| `DELNEXT` | Delnext. |
| `RCL` | Red Carpet Logistics. |
| `CGS_EXPRESS` | CGS Express. |
| `HK_POST` | Hongkong Post (www.hongkongpost.hk). |
| `SAP_EXPRESS` | SAP EXPRESS. |
| `PARCELPOST_SG` | Parcel Post Singapore. |
| `HERMES` | HermesWorld UK. |
| `IND_SAFEEXPRESS` | Safexpress. |
| `TOPHATTEREXPRESS` | Tophatter Express. |
| `MGLOBAL` | PT MGLOBAL LOGISTICS INDONESIA. |
| `AVERITT` | Averitt Express. |
| `LEADER` | leader. |
| `_2EBOX` | 2ebox courier. |
| `SG_SPEEDPOST` | Singapore Speedpost. |
| `DBSCHENKER_SE` | DB Schenker (www.dbschenker.com). |
| `ISR_POST_DOMESTIC` | Israel Post Domestic. |
| `BESTWAYPARCEL` | Best Way Parcel. |
| `ASENDIA_DE` | asendia_de. |
| `NIGHTLINE_UK` | nightline_uk. |
| `TAQBIN_SG` | taqbin_sg. |
| `TCK_EXPRESS` | TCK Express. |
| `ENDEAVOUR_DELIVERY` | Endeavour Delivery. |
| `NANJINGWOYUAN` | Nanjing Woyuan. |
| `HEPPNER_FR` | Heppner France. |
| `EMPS_CN` | EMPS Express. |
| `FONSEN` | Fonsen Logistics. |
| `PICKRR` | Pickrr. |
| `APC_OVERNIGHT_CONNUM` | APC Overnight Consignment. |
| `STAR_TRACK_NEXT_FLIGHT` | Star Track Next Flight. |
| `DAJIN` | Shanghai Aqrum Chemical Logistics Co.Ltd. |
| `UPS_FREIGHT` | UPS Freight. |
| `POSTA_PLUS` | Posta Plus. |
| `CEVA` | CEVA LOGISTICS. |
| `ANSERX` | ANSERX courier. |
| `JS_EXPRESS` | JS EXPRESS. |
| `PADTF` | padtf.com. |
| `UPS_MAIL_INNOVATIONS` | UPS Mail Innovations. |
| `SYPOST` | Sunyou Post. |
| `AMAZON_SHIP_MCF` | Amazon Shipping + Amazon MCF. |
| `YUSEN` | Yusen Logistics. |
| `BRING` | Bring. |
| `SDA_IT` | SDA Italy. |
| `GBA` | GBA Services Ltd. |
| `NEWEGGEXPRESS` | Newegg Express. |
| `SPEEDCOURIERS_GR` | Speed Couriers. |
| `FORRUN` | forrun Pvt Ltd (Arpatech Venture). |
| `PICKUP` | Pickupp. |
| `ECMS` | ECMS International Logistics Co.. |
| `INTELIPOST` | Intelipost (TMS for LATAM). |
| `FLASHEXPRESS` | Flash Express. |
| `CN_STO` | STO Express. |
| `SEKO_SFTP` | SEKO Worldwide. |
| `HOME_DELIVERY_SOLUTIONS` | Home Delivery Solutions Ltd. |
| `DPD_HGRY` | DPD Hungary. |
| `KERRYTTC_VN` | Kerry Express (Vietnam) Co Ltd. |
| `JOYING_BOX` | Joying Box. |
| `TOTAL_EXPRESS` | Total Express. |
| `ZJS_EXPRESS` | ZJS International. |
| `STARKEN` | STARKEN couriers. |
| `DEMANDSHIP` | DemandShip. |
| `CN_DPEX` | DPEX. |
| `AUPOST_CN` | AuPost China. |
| `LOGISTERS` | Logisters. |
| `GOGLOBALPOST` | Global Post. |
| `GLS_CZ` | GLS Czech Republic. |
| `PAACK_WEBHOOK` | Paack courier. |
| `GRAB_WEBHOOK` | Grab courier. |
| `PARCELPOINT` | Parcelpoint. |
| `ICUMULUS` | iCumulus. |
| `DAIGLOBALTRACK` | DAI Post. |
| `GLOBAL_IPARCEL` | i-parcel. |
| `YURTICI_KARGO` | Yurtici Kargo. |
| `CN_PAYPAL_PACKAGE` | PayPal Package. |
| `PARCEL_2_POST` | Parcel To Post. |
| `GLS_IT` | GLS Italy. |
| `PIL_LOGISTICS` | PIL Logistics (China) Co.. |
| `HEPPNER` | Heppner Internationale Spedition GmbH & Co.. |
| `GENERAL_OVERNIGHT` | Go!Express and logistics. |
| `HAPPY2POINT` | Happy 2ThePoint. |
| `CHITCHATS` | Chit Chats. |
| `SMOOTH` | Smooth Couriers. |
| `CLE_LOGISTICS` | CL E-Logistics Solutions Limited. |
| `FIEGE` | Fiege Logistics. |
| `MX_CARGO` | M&X cargo. |
| `ZIINGFINALMILE` | Ziing Final Mile Inc. |
| `DAYTON_FREIGHT` | Dayton Freight. |
| `TCS` | TCS courier. |
| `AEX` | AEX Group. |
| `HERMES_DE` | Hermes Germany. |
| `ROUTIFIC_WEBHOOK` | Routific. |
| `GLOBAVEND` | Globavend. |
| `CJ_LOGISTICS` | CJ Logistics International. |
| `PALLET_NETWORK` | The Pallet Network. |
| `RAF_PH` | RAF Philippines. |
| `UK_XDP` | XDP Express. |
| `PAPER_EXPRESS` | Paper Express. |
| `LA_POSTE_SUIVI` | La Poste. |
| `PAQUETEXPRESS` | Paquetexpress. |
| `LIEFERY` | liefery. |
| `STRECK_TRANSPORT` | Streck Transport. |
| `PONY_EXPRESS` | Pony express. |
| `ALWAYS_EXPRESS` | Always Express. |
| `GBS_BROKER` | GBS-Broker. |
| `CITYLINK_MY` | City-Link Express. |
| `ALLJOY` | ALLJOY SUPPLY CHAIN. |
| `YODEL` | yodel. |
| `YODEL_DIR` | Yodel Direct. |
| `STONE3PL` | STONE3PL. |
| `PARCELPAL_WEBHOOK` | ParcelPal. |
| `DHL_ECOMERCE_ASA` | DHL eCommerce Asia (API). |
| `SIMPLYPOST` | J&T Express Singapore. |
| `KY_EXPRESS` | Kua Yue Express. |
| `SHENZHEN` | shenzhen 1st International Logistics(Group)Co. |
| `US_LASERSHIP` | LaserShip. |
| `UC_EXPRE` | ucexpress. |
| `DIDADI` | DIDADI Logistics tech. |
| `CJ_KR` | CJ Korea Express. |
| `DBSCHENKER_B2B` | DB Schenker B2B. |
| `MXE` | MXE Express. |
| `CAE_DELIVERS` | CAE Delivers. |
| `PFCEXPRESS` | PFC Express. |
| `WHISTL` | Whistl. |
| `WEPOST` | WePost Sdn Bhd. |
| `DHL_PARCEL_ES` | DHL parcel Spain(www.dhl.com). |
| `DDEXPRESS` | DD Express Courier. |
| `ARAMEX_AU` | Aramex Australia (formerly Fastway AU). |
| `BNEED` | Bneed courier. |
| `HK_TGX` | Kerry Express Hong Kong. |
| `LATVIJAS_PASTS` | Latvijas Pasts. |
| `VIAEUROPE` | ViaEurope. |
| `CORREO_UY` | Correo Uruguayo. |
| `CHRONOPOST_FR` | Chronopost france (www.chronopost.fr). |
| `J_NET` | J-Net. |
| `_6LS` | 6ls.com. |
| `BLR_BELPOST` | Belpost. |
| `BIRDSYSTEM` | BirdSystem. |
| `DOBROPOST` | DobroPost. |
| `WAHANA_ID` | Wahana express (www.wahana.com). |
| `WEASHIP` | Weaship. |
| `SONICTL` | Sonic Transportation & Logistics. |
| `KWT` | Shenzhen Jinghuada Logistics Co.. |
| `AFLLOG_FTP` | AFL LOGISTICS. |
| `SKYNET_WORLDWIDE` | SkyNet Worldwide Express. |
| `NOVA_POSHTA` | Nova Poshta (novaposhta.ua). |
| `SEINO` | Seino. |
| `SZENDEX` | SZENDEX. |
| `BPOST_INT` | Bpost international. |
| `DBSCHENKER_SV` | DB Schenker Sweden. |
| `AO_DEUTSCHLAND` | AO Deutschland. |
| `EU_FLEET_SOLUTIONS` | EU Fleet Solutions. |
| `PCFCORP` | PCF Final Mile. |
| `LINKBRIDGE` | Link Bridge(BeiJing)international logistics co.. |
| `PRIMAMULTICIPTA` | PT Prima Multi Cipta. |
| `COUREX` | Urbanfox. |
| `ZAJIL_EXPRESS` | Zajil Express Company. |
| `COLLECTCO` | CollectCo. |
| `JTEXPRESS` | J&T EXPRESS MALAYSIA. |
| `FEDEX_UK` | FedEx® UK. |
| `USHIP` | uShip courier. |
| `PIXSELL` | PIXSELL LOGISTICS. |
| `SHIPTOR` | Shiptor. |
| `CDEK` | CDEK courier. |
| `VNM_VIETTELPOST` | ViettelPost. |
| `CJ_CENTURY` | CJ Century. |
| `GSO` | GSO(GLS-USA). |
| `VIWO` | VIWO IoT. |
| `SKYBOX` | SKYBOX. |
| `KERRYTJ` | Kerry TJ Logistics. |
| `NTLOGISTICS_VN` | Nhat Tin Logistics. |
| `SDH_SCM` | lightning monkey. |
| `ZINC` | Zinc courier. |
| `DPE_SOUTH_AFRC` | DPE South Africa. |
| `CESKA_CZ` | Czech Post. |
| `ACS_GR` | ACS Courier. |
| `DEALERSEND` | DealerSend. |
| `JOCOM` | Jocom. |
| `CSE` | CSE courier. |
| `TFORCE_FINALMILE` | TForce Final Mile. |
| `SHIP_GATE` | ShipGate. |
| `SHIPTER` | SHIPTER. |
| `NATIONAL_SAMEDAY` | National Sameday. |
| `YUNEXPRESS` | YunExpress. |
| `CAINIAO` | AliExpress Standard Shipping. |
| `DMS_MATRIX` | DMSMatrix. |
| `DIRECTLOG` | Directlog (www.directlog.com.br). |
| `ASENDIA_US` | Asendia USA. |
| `_3JMSLOGISTICS` | 3JMS Logistics. |
| `LICCARDI_EXPRESS` | LICCARDI EXPRESS COURIER. |
| `SKY_POSTAL` | SkyPostal. |
| `CNWANGTONG` | cnwangtong. |
| `POSTNORD_LOGISTICS_DK` | ostnord denmark. |
| `LOGISTIKA` | Logistika. |
| `CELERITAS` | Celeritas Transporte. |
| `PRESSIODE` | Pressio. |
| `SHREE_MARUTI` | Shree Maruti Courier Services Pvt Ltd. |
| `LOGISTICSWORLDWIDE_HK` | Logistic Worldwide Express (LWE Honkong). |
| `EFEX` | eFEx (E-Commerce Fulfillment & Express). |
| `LOTTE` | Lotte Global Logistics. |
| `LONESTAR` | Lone Star Overnight. |
| `APRISAEXPRESS` | Aprisa Express. |
| `BEL_RS` | BEL North Russia. |
| `OSM_WORLDWIDE` | OSM Worldwide. |
| `WESTGATE_GL` | Westgate Global. |
| `FASTRACK` | Fasttrack. |
| `DTD_EXPR` | DTD Express. |
| `ALFATREX` | AlfaTrex. |
| `PROMEDDELIVERY` | ProMed Delivery. |
| `THABIT_LOGISTICS` | Thabit Logistics. |
| `HCT_LOGISTICS` | HCT LOGISTICS CO.LTD.. |
| `CARRY_FLAP` | Carry-Flap Co.. |
| `US_OLD_DOMINION` | Old Dominion Freight Line. |
| `ANICAM_BOX` | ANICAM BOX EXPRESS. |
| `WANBEXPRESS` | WanbExpress. |
| `AN_POST` | An Post. |
| `DPD_LOCAL` | DPD Local. |
| `STALLIONEXPRESS` | Stallion Express. |
| `RAIDEREX` | RaidereX. |
| `SHOPFANS` | ShopfansRU LLC. |
| `KYUNGDONG_PARCEL` | Kyungdong Parcel. |
| `CHAMPION_LOGISTICS` | Champion Logistics. |
| `PICKUPP_SGP` | PICK UPP (Singapore). |
| `MORNING_EXPRESS` | Morning Express. |
| `NACEX` | NACEX. |
| `THENILE_WEBHOOK` | SortHub courier. |
| `HOLISOL` | Holisol. |
| `LBCEXPRESS_FTP` | LBC EXPRESS INC.. |
| `KURASI` | KURASI. |
| `USF_REDDAWAY` | USF Reddaway. |
| `APG` | APG eCommerce Solutions. |
| `CN_BOXC` | BoxC courier. |
| `ECOSCOOTING` | ECOSCOOTING. |
| `MAINWAY` | Mainway. |
| `PAPERFLY` | Paperfly Private Limited. |
| `HOUNDEXPRESS` | Hound Express. |
| `BOX_BERRY` | Boxberry courier. |
| `EP_BOX` | EP-Box courier. |
| `PLUS_LOG_UK` | Plus UK Logistics. |
| `FULFILLA` | Fulfilla. |
| `ASE` | ASE KARGO. |
| `MAIL_PLUS` | MailPlus. |
| `XPO_LOGISTICS` | XPO logistics. |
| `WNDIRECT` | wnDirect. |
| `CLOUDWISH_ASIA` | Cloudwish Asia. |
| `ZELERIS` | Zeleris. |
| `GIO_EXPRESS` | Gio Express. |
| `OCS_WORLDWIDE` | OCS WORLDWIDE. |
| `ARK_LOGISTICS` | ARK Logistics. |
| `AQUILINE` | Aquiline. |
| `PILOT_FREIGHT` | Pilot Freight Services. |
| `QWINTRY` | Qwintry Logistics. |
| `DANSKE_FRAGT` | Danske Fragtaend. |
| `CARRIERS` | Carriers courier. |
| `AIR_CANADA_GLOBAL` | Rivo (Air canada). |
| `PRESIDENT_TRANS` | PRESIDENT TRANSNET CORP. |
| `STEPFORWARDFS` | STEP FORWARD FREIGHT SERVICE CO LTD. |
| `SKYNET_UK` | Skynet UK. |
| `PITTOHIO` | PITT OHIO. |
| `CORREOS_EXPRESS` | Correos Express. |
| `RL_US` | RL Carriers. |
| `DESTINY` | Destiny Transportation. |
| `UK_YODEL` | Yodel (www.yodel.co.uk). |
| `COMET_TECH` | CometTech. |
| `DHL_PARCEL_RU` | DHL Parcel Russia. |
| `TNT_REFR` | TNT Reference. |
| `SHREE_ANJANI_COURIER` | Shree Anjani Courier. |
| `MIKROPAKKET_BE` | Mikropakket Belgium. |
| `ETS_EXPRESS` | RETS express. |
| `COLIS_PRIVE` | Colis Privé. |
| `CN_YUNDA` | Yunda Express. |
| `AAA_COOPER` | AAA Cooper. |
| `ROCKET_PARCEL` | Rocket Parcel International. |
| `_360LION` | 360 Lion Express. |
| `PANDU` | PANDU. |
| `PROFESSIONAL_COURIERS` | PROFESSIONAL COURIERS. |
| `FLYTEXPRESS` | FLYTEXPRESS. |
| `LOGISTICSWORLDWIDE_MY` | LOGISTICSWORLDWIDE MY. |
| `CORREOS_DE_ESPANA` | CORREOS DE ESPANA. |
| `IMX` | IMX. |
| `FOUR_PX_EXPRESS` | FOUR PX EXPRESS. |
| `XPRESSBEES` | XPRESSBEES. |
| `PICKUPP_VNM` | pickupp_vnm. |
| `STARTRACK_EXPRESS1` | startrack_express. |
| `FR_COLISSIMO` | fr_colissimo. |
| `NACEX_SPAIN_REFERENCE` | nacex_spain_reference. |
| `DHL_SUPPLY_CHAIN_AU` | dhl_supply_chain_au. |
| `ESHIPPING` | Eshipping. |
| `SHREETIRUPATI` | SHREE TIRUPATI COURIER SERVICES PVT. LTD.. |
| `HX_EXPRESS` | HX Express. |
| `INDOPAKET` | INDOPAKET. |
| `CN_17POST` | 17 Post Service. |
| `K1_EXPRESS` | K1 Express. |
| `CJ_GLS` | CJ GLS. |
| `MYS_GDEX` | GDEX courier. |
| `NATIONEX` | Nationex courier. |
| `ANJUN` | Anjun couriers. |
| `FARGOOD` | FarGood. |
| `SMG_EXPRESS` | SMG Direct. |
| `RZYEXPRESS` | RZY Express. |
| `SEFL` | Southeastern Freight Lines. |
| `TNT_CLICK_IT` | TNT-Click Italy. |
| `HDB` | Haidaibao. |
| `HIPSHIPPER` | Hipshipper. |
| `RPXLOGISTICS` | RPX Logistics. |
| `KUEHNE` | Kuehne + Nagel. |
| `IT_NEXIVE` | Nexive (TNT Post Italy). |
| `PTS` | PTS courier. |
| `SWISS_POST_FTP` | Swiss Post FTP. |
| `FASTRK_SERV` | Fastrak Services. |
| `_4_72` | 4-72 Entregando. |
| `US_YRC` | YRC courier. |
| `POSTNL_INTL_3S` | PostNL International 3S. |
| `ELIAN_POST` | Yilian (Elian) Supply Chain. |
| `CUBYN` | Cubyn. |
| `SAU_SAUDI_POST` | Saudi Post. |
| `ABXEXPRESS_MY` | ABX Express. |
| `HUAHAN_EXPRESS` | HUAHANG EXPRESS. |
| `ZES_EXPRESS` | Eshun international Logistic. |
| `ZEPTO_EXPRESS` | ZeptoExpress. |
| `SKYNET_ZA` | Skynet World Wide Express South Africa. |
| `ZEEK_2_DOOR` | Zeek2Door. |
| `BLINKLASTMILE` | Blink. |
| `POSTA_UKR` | UkrPoshta. |
| `CHROBINSON` | C.H. Robinson Worldwide. |
| `CN_POST56` | Post56. |
| `COURANT_PLUS` | Courant Plus. |
| `SCUDEX_EXPRESS` | Scudex Express. |
| `SHIPENTEGRA` | ShipEntegra. |
| `B_TWO_C_EUROPE` | B2C courier Europe. |
| `COPE` | Cope Sensitive Freight. |
| `IND_GATI` | Gati-KWE. |
| `CN_WISHPOST` | WishPost. |
| `NACEX_ES` | NACEX Spain. |
| `TAQBIN_HK` | TAQBIN Hong Kong. |
| `GLOBALTRANZ` | GlobalTranz. |
| `HKD` | Qingdao HKD International Logistics. |
| `BJSHOMEDELIVERY` | BJS Distribution courier. |
| `OMNIVA` | Omniva. |
| `SUTTON` | Sutton Transport. |
| `PANTHER_REFERENCE` | Panther Reference. |
| `SFCSERVICE` | SFC Service. |
| `LTL` | LTL COURIER. |
| `PARKNPARCEL` | Park N Parcel. |
| `SPRING_GDS` | Spring GDS. |
| `ECEXPRESS` | ECexpress. |
| `INTERPARCEL_AU` | Interparcel Australia. |
| `AGILITY` | Agility. |
| `XL_EXPRESS` | XL Express. |
| `ADERONLINE` | Ader couriers. |
| `DIRECTCOURIERS` | Direct Couriers. |
| `PLANZER` | Planzer Group. |
| `SENDING` | Sending Transporte Urgente y Comunicacion. |
| `NINJAVAN_WB` | Ninjavan Webhook. |
| `NATIONWIDE_MY` | Nationwide Express Courier Services Bhd (www.nationwide.com.my). |
| `SENDIT` | Sendit. |
| `GB_ARROW` | Arrow XL. |
| `IND_GOJAVAS` | GoJavas. |
| `KPOST` | Korea Post. |
| `DHL_FREIGHT` | DHL Freight. |
| `BLUECARE` | Bluecare Express Ltd. |
| `JINDOUYUN` | jindouyun courier. |
| `TRACKON` | Trackon Couriers Pvt. Ltd. |
| `GB_TUFFNELLS` | Tuffnells Parcels Express. |
| `TRUMPCARD` | TRUMPCARD LLC. |
| `ETOTAL` | eTotal Solution Limited. |
| `SFPLUS_WEBHOOK` | Zeek courier. |
| `SEKOLOGISTICS` | SEKO Logistics. |
| `HERMES_2MANN_HANDLING` | Hermes Einrichtungs Service GmbH & Co. KG. |
| `DPD_LOCAL_REF` | DPD Local reference. |
| `UDS` | United Delivery Service. |
| `ZA_SPECIALISED_FREIGHT` | Specialised Freight. |
| `THA_KERRY` | Kerry Express Thailand. |
| `PRT_INT_SEUR` | SEUR International. |
| `BRA_CORREIOS` | Correios Brazil. |
| `NZ_NZ_POST` | New Zealand Post. |
| `CN_EQUICK` | Equick China. |
| `MYS_EMS` | Malaysia Post EMS / Pos Laju. |
| `GB_NORSK` | Norsk Global. |
| `ESP_MRW` | MRW spain. |
| `ESP_PACKLINK` | Packlink. |
| `KANGAROO_MY` | Kangaroo Worldwide Express. |
| `RPX` | RPX Online. |
| `XDP_UK_REFERENCE` | XDP Express Reference. |
| `NINJAVAN_MY` | ninja van (www.ninjavan.co). |
| `ADICIONAL` | Adicional Logistics. |
| `ROADBULL` | Red Carpet Logistics. |
| `YAKIT` | Yakit courier. |
| `MAILAMERICAS` | MailAmericas. |
| `MIKROPAKKET` | Mikropakket. |
| `DYNALOGIC` | Dynamic Logistics. |
| `DHL_ES` | DHL Spain(www.dhl.com). |
| `DHL_PARCEL_NL` | DHL Parcel NL. |
| `DHL_GLOBAL_MAIL_ASIA` | DHL Global Mail Asia (www.dhl.com). |
| `DAWN_WING` | Dawn Wing. |
| `GENIKI_GR` | Geniki Taxydromiki. |
| `HERMESWORLD_UK` | hermesworld_uk. |
| `ALPHAFAST` | Alphafast (www.alphafast.com). |
| `BUYLOGIC` | buylogic. |
| `EKART` | Ekart logistics (ekartlogistics.com). |
| `MEX_SENDA` | mexico senda express. |
| `SFC_LOGISTICS` | SFC. |
| `POST_SERBIA` | Posta Serbia. |
| `IND_DELHIVERY` | Delhivery India. |
| `DE_DPD_DELISTRACK` | DPD Germany. |
| `RPD2MAN` | RPD2man Deliveries. |
| `CN_SF_EXPRESS` | SF Express (www.sf-express.com). |
| `YANWEN` | Yanwen Logistics. |
| `MYS_SKYNET` | Skynet Malaysia. |
| `CORREOS_DE_MEXICO` | correos mexico. |
| `CBL_LOGISTICA` | CBL Logistica. |
| `MEX_ESTAFETA` | Estafeta (www.estafeta.com). |
| `AU_AUSTRIAN_POST` | Austrian Post (Registered). |
| `RINCOS` | Rincos. |
| `NLD_DHL` | DHL Netherland. |
| `RUSSIAN_POST` | Russian post. |
| `COURIERS_PLEASE` | CouriersPlease (couriersplease.com.au). |
| `POSTNORD_LOGISTICS` | PostNord Logistics. |
| `FEDEX` | Fedex. |
| `DPE_EXPRESS` | DPE Express. |
| `DPD` | DPD. |
| `ADSONE` | ADSone. |
| `IDN_JNE` | JNE Express (Jalur Nugraha Ekakurir). |
| `THECOURIERGUY` | The Courier Guy. |
| `CNEXPS` | CNE Express. |
| `PRT_CHRONOPOST` | Chronopost Portugal. |
| `LANDMARK_GLOBAL` | Landmark Global. |
| `IT_DHL_ECOMMERCE` | DHL International. |
| `ESP_NACEX` | NACEX Spain. |
| `PRT_CTT` | CTT Portugal. |
| `BE_KIALA` | Kiala. |
| `ASENDIA_UK` | Asendia UK. |
| `GLOBAL_TNT` | TNT global. |
| `POSTUR_IS` | Iceland Post. |
| `EPARCEL_KR` | eParcel Korea. |
| `INPOST_PACZKOMATY` | InPost Paczkomaty. |
| `IT_POSTE_ITALIA` | Poste italiane (www.poste.it). |
| `BE_BPOST` | Bpost (www.bpost.be). |
| `PL_POCZTA_POLSKA` | Poczta Polska (www.poczta-polska.pl). |
| `MYS_MYS_POST` | Malaysia Post. |
| `SG_SG_POST` | Singapore Post. |
| `THA_THAILAND_POST` | Thailand Post (www.thailandpost.co.th). |
| `LEXSHIP` | LexShip. |
| `FASTWAY_NZ` | Fastway New Zealand. |
| `DHL_AU` | DHL Supply Chain Australia. |
| `COSTMETICSNOW` | Cosmetics Now. |
| `PFLOGISTICS` | PFL. |
| `LOOMIS_EXPRESS` | Loomis Express. |
| `GLS_ITALY` | GLS Italy. |
| `LINE` | Line Clear Express & Logistics Sdn Bhd. |
| `GEL_EXPRESS` | Gel Express Logistik. |
| `HUODULL` | Huodull. |
| `NINJAVAN_SG` | Ninja van Singapore. |
| `JANIO` | Janio Asia. |
| `AO_COURIER` | AO Logistics. |
| `BRT_IT_SENDER_REF` | BRT Bartolini(Sender Reference). |
| `SAILPOST` | SAILPOST. |
| `LALAMOVE` | Lalamove. |
| `NEWZEALAND_COURIERS` | NEW ZEALAND COURIERS. |
| `ETOMARS` | Etomars. |
| `VIRTRANSPORT` | VIR Transport. |
| `WIZMO` | Wizmo. |
| `PALLETWAYS` | Palletways. |
| `I_DIKA` | i-dika. |
| `CFL_LOGISTICS` | CFL Logistics. |
| `GEMWORLDWIDE` | GEM Worldwide. |
| `GLOBAL_EXPRESS` | Tai Wan Global Business. |
| `LOGISTYX_TRANSGROUP` | Transgroup courier. |
| `WESTBANK_COURIER` | West Bank Courier. |
| `ARCO_SPEDIZIONI` | Arco Spedizioni SP. |
| `YDH_EXPRESS` | YDH express. |
| `PARCELINKLOGISTICS` | Parcelink Logistics. |
| `CNDEXPRESS` | CND Express. |
| `NOX_NIGHT_TIME_EXPRESS` | NOX NightTimeExpress. |
| `AERONET` | Aeronet couriers. |
| `LTIANEXP` | LTIAN EXP. |
| `INTEGRA2_FTP` | Integra2. |
| `PARCELONE` | PARCEL ONE. |
| `NOX_NACHTEXPRESS` | Innight Express Germany GmbH (nox NachtExpress). |
| `CN_CHINA_POST_EMS` | China Post. |
| `CHUKOU1` | Chukou1. |
| `GLS_SLOV` | GLS General Logistics Systems Slovakia s.r.o.. |
| `ORANGE_DS` | OrangeDS (Orange Distribution Solutions Inc). |
| `JOOM_LOGIS` | Joom Logistics. |
| `AUS_STARTRACK` | StarTrack (startrack.com.au). |
| `DHL` | dhl Global. |
| `GB_APC` | APC postal logistics germany. |
| `BONDSCOURIERS` | Bonds Courier Service (bondscouriers.com.au). |
| `JPN_JAPAN_POST` | Japan Post. |
| `USPS` | United States Postal Service. |
| `WINIT` | WinIt. |
| `ARG_OCA` | OCA Argentina. |
| `TW_TAIWAN_POST` | Taiwan Post. |
| `DMM_NETWORK` | DMM Network. |
| `TNT` | TNT Express. |
| `BH_POSTA` | BH Posta (www.posta.ba). |
| `SWE_POSTNORD` | Postnord sweden. |
| `CA_CANADA_POST` | Canada Post. |
| `WISELOADS` | Wiseloads. |
| `ASENDIA_HK` | Asendia HonKong. |
| `NLD_GLS` | GLS Netherland. |
| `MEX_REDPACK` | Redpack. |
| `JET_SHIP` | Jet-Ship Worldwide. |
| `DE_DHL_EXPRESS` | DHL Express. |
| `NINJAVAN_THAI` | Ninja van Thai. |
| `RABEN_GROUP` | Raben Group. |
| `ESP_ASM` | ASM(GLS Spain). |
| `HRV_HRVATSKA` | Hrvatska posta. |
| `GLOBAL_ESTES` | Estes Express Lines. |
| `LTU_LIETUVOS` | Lietuvos pastas. |
| `BEL_DHL` | DHL Benelux. |
| `AU_AU_POST` | Australia Post. |
| `SPEEDEXCOURIER` | SPEEDEX couriers. |
| `FR_COLIS` | Colissimo. |
| `ARAMEX` | Aramex. |
| `DPEX` | DPEX (www.dpex.com). |
| `MYS_AIRPAK` | Airpak Express. |
| `CUCKOOEXPRESS` | Cuckoo Express. |
| `DPD_POLAND` | DPD Poland. |
| `NLD_POSTNL` | PostNL International. |
| `NIM_EXPRESS` | Nim Express. |
| `QUANTIUM` | Quantium. |
| `SENDLE` | Sendle. |
| `ESP_REDUR` | Redur Spain. |
| `MATKAHUOLTO` | Matkahuolto. |
| `CPACKET` | Cpacket couriers. |
| `POSTI` | Posti courier. |
| `HUNTER_EXPRESS` | Hunter Express. |
| `CHOIR_EXP` | Choir Express Indonesia. |
| `LEGION_EXPRESS` | Legion Express. |
| `AUSTRIAN_POST_EXPRESS` | austrian post. |
| `GRUPO` | Grupo ampm. |
| `POSTA_RO` | Post Roman (www.posta-romana.ro). |
| `INTERPARCEL_UK` | Interparcel UK. |
| `GLOBAL_ABF` | ABF Freight. |
| `POSTEN_NORGE` | Posten Norge (www.posten.no). |
| `XPERT_DELIVERY` | Xpert Delivery. |
| `DHL_REFR` | DHl (Reference number). |
| `DHL_HK` | DHL HonKong. |
| `SKYNET_UAE` | SKYNET UAE. |
| `GOJEK` | Gojek. |
| `YODEL_INTNL` | Yodel International. |
| `JANCO` | Janco Ecommerce. |
| `YTO` | YTO Express. |
| `WISE_EXPRESS` | Wise Express. |
| `JTEXPRESS_VN` | J&T Express Vietnam. |
| `FEDEX_INTL_MLSERV` | FedEx International MailService. |
| `VAMOX` | VAMOX. |
| `AMS_GRP` | AMS Group. |
| `DHL_JP` | DHL Japan. |
| `HRPARCEL` | HR Parcel. |
| `GESWL` | GESWL Express. |
| `BLUESTAR` | Blue Star. |
| `CDEK_TR` | CDEK TR. |
| `DESCARTES` | Innovel courier. |
| `DELTEC_UK` | Deltec Courier. |
| `DTDC_EXPRESS` | DTDC express. |
| `TOURLINE` | tourline. |
| `BH_WORLDWIDE` | B&H Worldwide. |
| `OCS` | OCS ANA Group. |
| `YINGNUO_LOGISTICS` | yingnuo logistics. |
| `UPS` | United Parcel Service. |
| `TOLL` | Toll IPEC. |
| `PRT_SEUR` | SEUR portugal. |
| `DTDC_AU` | DTDC Australia. |
| `THA_DYNAMIC_LOGISTICS` | Dynamic Logistics. |
| `UBI_LOGISTICS` | UBI Smart Parcel. |
| `FEDEX_CROSSBORDER` | FedEx Cross Border. |
| `A1POST` | A1Post. |
| `TAZMANIAN_FREIGHT` | Tazmanian Freight Systems. |
| `CJ_INT_MY` | CJ International malaysia. |
| `SAIA_FREIGHT` | Saia LTL Freight. |
| `SG_QXPRESS` | Qxpress. |
| `NHANS_SOLUTIONS` | Nhans Solutions. |
| `DPD_FR` | DPD France. |
| `COORDINADORA` | Coordinadora. |
| `ANDREANI` | Grupo logistico Andreani. |
| `DOORA` | Doora Logistics. |
| `INTERPARCEL_NZ` | Interparcel New Zealand. |
| `PHL_JAMEXPRESS` | Jam Express Philippines. |
| `BEL_BELGIUM_POST` | bel_belgium_post. |
| `US_APC` | us_apc. |
| `IDN_POS` | idn_pos. |
| `FR_MONDIAL` | fr_mondial. |
| `DE_DHL` | DE DHL. |
| `HK_RPX` | hk_rpx. |
| `DHL_PIECEID` | dhl_pieceid. |
| `VNPOST_EMS` | vnpost_ems. |
| `RRDONNELLEY` | rrdonnelley. |
| `DPD_DE` | dpd_de. |
| `DELCART_IN` | delcart_in. |
| `IMEXGLOBALSOLUTIONS` | imexglobalsolutions. |
| `ACOMMERCE` | ACOMMERCE. |
| `EURODIS` | eurodis. |
| `CANPAR` | CANPAR. |
| `GLS` | GLS. |
| `IND_ECOM` | Ecom Express. |
| `ESP_ENVIALIA` | Envialia. |
| `DHL_UK` | dhl UK. |
| `SMSA_EXPRESS` | SMSA Express. |
| `TNT_FR` | TNT France. |
| `DEX_I` | DEX-I courier. |
| `BUDBEE_WEBHOOK` | Budbee courier. |
| `COPA_COURIER` | Copa Airlines Courier. |
| `VNM_VIETNAM_POST` | Vietnam Post. |
| `DPD_HK` | DPD HongKong. |
| `TOLL_NZ` | Toll New Zealand. |
| `ECHO_` | Echo courier. |
| `FEDEX_FR` | FedEx® Freight. |
| `BORDEREXPRESS` | Border Express. |
| `MAILPLUS_JPN` | MailPlus (Japan). |
| `TNT_UK_REFR` | TNT UK Reference. |
| `KEC` | KEC courier. |
| `DPD_RO` | DPD Romania. |
| `TNT_JP` | TNT_JP. |
| `TH_CJ` | TH_CJ. |
| `EC_CN` | EC_CN. |
| `FASTWAY_UK` | FASTWAY_UK. |
| `FASTWAY_US` | FASTWAY_US. |
| `GLS_DE` | GLS_DE. |
| `GLS_ES` | GLS_ES. |
| `GLS_FR` | GLS_FR. |
| `MONDIAL_BE` | MONDIAL_BE. |
| `SGT_IT` | SGT_IT. |
| `TNT_CN` | TNT_CN. |
| `TNT_DE` | TNT_DE. |
| `TNT_ES` | TNT_ES. |
| `TNT_PL` | TNT_PL. |
| `PARCELFORCE` | PARCELFORCE. |
| `SWISS_POST` | SWISS POST. |
| `TOLL_IPEC` | TOLL IPEC. |
| `AIR_21` | AIR 21. |
| `AIRSPEED` | AIRSPEED. |
| `BERT` | BERT. |
| `BLUEDART` | BLUEDART. |
| `COLLECTPLUS` | COLLECTPLUS. |
| `COURIERPLUS` | COURIERPLUS. |
| `COURIER_POST` | COURIER POST. |
| `DHL_GLOBAL_MAIL` | dhl_global_mail. |
| `DPD_UK` | dpd_uk. |
| `DELTEC_DE` | DELTEC DE. |
| `DEUTSCHE_DE` | deutsche_de. |
| `DOTZOT` | DOTZOT. |
| `ELTA_GR` | elta_gr. |
| `EMS_CN` | ems_cn. |
| `ECARGO` | ECARGO. |
| `ENSENDA` | ENSENDA. |
| `FERCAM_IT` | fercam_it. |
| `FASTWAY_ZA` | fastway_za. |
| `FASTWAY_AU` | fastway_au. |
| `FIRST_LOGISITCS` | first_logisitcs. |
| `GEODIS` | GEODIS. |
| `GLOBEGISTICS` | GLOBEGISTICS. |
| `GREYHOUND` | GREYHOUND. |
| `JETSHIP_MY` | jetship_my. |
| `LION_PARCEL` | LION PARCEL. |
| `AEROFLASH` | AEROFLASH. |
| `ONTRAC` | ONTRAC. |
| `SAGAWA` | SAGAWA. |
| `SIODEMKA` | SIODEMKA. |
| `STARTRACK` | startrack. |
| `TNT_AU` | tnt_au. |
| `TNT_IT` | tnt_it. |
| `TRANSMISSION` | TRANSMISSION. |
| `YAMATO` | YAMATO. |
| `DHL_IT` | dhl_it. |
| `DHL_AT` | dhl_at. |
| `LOGISTICSWORLDWIDE_KR` | LOGISTICSWORLDWIDE KR. |
| `GLS_SPAIN` | gls_spain. |
| `AMAZON_UK_API` | amazon_uk_api. |
| `DPD_FR_REFERENCE` | dpd_fr_reference. |
| `DHLPARCEL_UK` | dhlparcel_uk. |
| `MEGASAVE` | megasave. |
| `QUALITYPOST` | qualitypost. |
| `IDS_LOGISTICS` | ids_logistics. |
| `JOYINGBOX1` | joyingbox. |
| `PANTHER_ORDER_NUMBER` | panther_order_number. |
| `WATKINS_SHEPARD` | watkins_shepard. |
| `FASTTRACK` | fasttrack. |
| `UP_EXPRESS` | up_express. |
| `ELOGISTICA` | elogistica. |
| `ECOURIER` | ecourier. |
| `CJ_PHILIPPINES` | cj_philippines. |
| `SPEEDEX` | speedex. |
| `ORANGECONNEX` | orangeconnex. |
| `TECOR` | tecor. |
| `SAEE` | saee. |
| `GLS_ITALY_FTP` | gls_italy_ftp. |
| `DELIVERE` | delivere. |
| `YYCOM` | yycom. |
| `ADICIONAL_PT` | Adicional Logistics. |
| `DKSH` | DKSH. |
| `NIPPON_EXPRESS_FTP` | Nippon Express. |
| `GOLS` | GO Logistics & Storage. |
| `FUJEXP` | FUJIE EXPRESS. |
| `QTRACK` | QTrack. |
| `OMLOGISTICS_API` | OM LOGISTICS LTD. |
| `GDPHARM` | GDPharm Logistics. |
| `MISUMI_CN` | MISUMI Group Inc.. |
| `AIR_CANADA` | Rivo. |
| `CITY56_WEBHOOK` | City Express. |
| `SAGAWA_API` | Sagawa. |
| `KEDAEX` | KedaEX. |
| `PGEON_API` | Pgeon. |
| `WEWORLDEXPRESS` | We World Express. |
| `JT_LOGISTICS` | J&T International logistics. |
| `TRUSK` | Trusk France. |
| `VIAXPRESS` | ViaXpress. |
| `DHL_SUPPLYCHAIN_ID` | DHL Supply Chain Indonesia. |
| `ZUELLIGPHARMA_SFTP` | Zuellig Pharma Korea. |
| `MEEST` | Meest. |
| `TOLL_PRIORITY` | Toll Priority. |
| `MOTHERSHIP_API` | Mothership. |
| `CAPITAL` | Capital Transport. |
| `EUROPAKET_API` | Europacket+. |
| `HFD` | HFD. |
| `TOURLINE_REFERENCE` | Tourline Express. |
| `GIO_ECOURIER` | GIO Express Inc. |
| `CN_LOGISTICS` | CN Logistics. |
| `PANDION` | Pandion. |
| `BPOST_API` | Bpost API. |
| `PASSPORTSHIPPING` | Passport Shipping. |
| `PAKAJO` | Pakajo World. |
| `DACHSER` | DACHSER. |
| `YUSEN_SFTP` | Yusen Logistics. |
| `SHYPLITE` | Shypmax. |
| `XYY` | Xingyunyi Logistics. |
| `MWD` | Metropolitan Warehouse & Delivery. |
| `FAXECARGO` | Faxe Cargo. |
| `MAZET` | Groupe Mazet. |
| `FIRST_LOGISTICS_API` | First Logistics. |
| `SPRINT_PACK` | SPRINT PACK. |
| `HERMES_DE_FTP` | Hermes Germany. |
| `CONCISE` | Concise. |
| `KERRY_EXPRESS_TW_API` | Kerry Express TaiWan. |
| `EWE` | EWE Global Express. |
| `FASTDESPATCH` | Fast Despatch Logistics Limited. |
| `ABCUSTOM_SFTP` | AB Custom Group. |
| `CHAZKI` | Chazki. |
| `SHIPPIE` | Shippie. |
| `GEODIS_API` | GEODIS - Distribution & Express. |
| `NAQEL_EXPRESS` | Naqel Express. |
| `PAPA_WEBHOOK` | Papa. |
| `FORWARDAIR` | Forward Air. |
| `DIALOGO_LOGISTICA_API` | Dialogo Logistica. |
| `LALAMOVE_API` | Lalamove. |
| `TOMYDOOR` | Tomydoor. |
| `KRONOS_WEBHOOK` | Kronos Express. |
| `JTCARGO` | J&T CARGO. |
| `T_CAT` | T-cat. |
| `CONCISE_WEBHOOK` | Concise. |
| `TELEPORT_WEBHOOK` | Teleport. |
| `CUSTOMCO_API` | The Custom Companies. |
| `SPX_TH` | Shopee Xpress. |
| `BOLLORE_LOGISTICS` | Bollore Logistics. |
| `CLICKLINK_SFTP` | ClickLink. |
| `M3LOGISTICS` | M3 Logistics. |
| `VNPOST_API` | Vietnam Post. |
| `AXLEHIRE_FTP` | Axlehire. |
| `SHADOWFAX` | Shadowfax. |
| `MYHERMES_UK_API` | EVRi. |
| `DAIICHI` | Daiichi Freight System Inc. |
| `MENSAJEROSURBANOS_API` | Mensajeros Urbanos. |
| `POLARSPEED` | PolarSpeed Inc. |
| `IDEXPRESS_ID` | iDexpress Indonesia. |
| `PAYO` | Payo. |
| `WHISTL_SFTP` | Whistl. |
| `INTEX_DE` | INTEX Paketdienst GmbH. |
| `TRANS2U` | Trans2u. |
| `PRODUCTCAREGROUP_SFTP` | Product Care Services Limited. |
| `BIGSMART` | Big Smart. |
| `EXPEDITORS_API_REF` | Expeditors API Reference. |
| `AITWORLDWIDE_API` | AIT. |
| `WORLDCOURIER` | World Courier. |
| `QUIQUP` | Quiqup. |
| `AGEDISS_SFTP` | Agediss. |
| `ANDREANI_API` | Andreani. |
| `CRLEXPRESS` | CRL Express. |
| `SMARTCAT` | SMARTCAT. |
| `CROSSFLIGHT` | Crossflight Limited. |
| `PROCARRIER` | Pro Carrier. |
| `DHL_REFERENCE_API` | DHL (Reference number). |
| `SEINO_API` | Seino. |
| `WSPEXPRESS` | WSP Express. |
| `KRONOS` | Kronos Express. |
| `TOTAL_EXPRESS_API` | Total Express. |
| `PARCLL` | PARCLL. |
| `XPEDIGO` | Xpedigo. |
| `STAR_TRACK_WEBHOOK` | StarTrack. |
| `GPOST` | Georgian Post. |
| `UCS` | UCS. |
| `DMFGROUP` | DMF. |
| `COORDINADORA_API` | Coordinadora. |
| `MARKEN` | Marken. |
| `NTL` | NTL logistics. |
| `REDJEPAKKETJE` | Red je Pakketje. |
| `ALLIED_EXPRESS_FTP` | Allied Express (FTP). |
| `MONDIALRELAY_ES` | Mondial Relay Spain(Punto Pack). |
| `NAEKO_FTP` | Naeko Logistics. |
| `MHI` | Mhi. |
| `SHIPPIFY` | Shippify, Inc. |
| `MALCA_AMIT_API` | Malca Amit. |
| `JTEXPRESS_SG_API` | J&T Express Singapore. |
| `DACHSER_WEB` | DACHSER. |
| `FLIGHTLG` | Flight Logistics Group. |
| `CAGO` | Cago. |
| `COM1EXPRESS` | ComOne Express. |
| `TONAMI_FTP` | Tonami. |
| `PACKFLEET` | PACKFLEET. |
| `PUROLATOR_INTERNATIONAL` | Purolator International. |
| `WINESHIPPING_WEBHOOK` | Wineshipping. |
| `DHL_ES_SFTP` | DHL Spain Domestic. |
| `PCHOME_API` | 網家速配股份有限公司. |
| `CESKAPOSTA_API` | Czech Post. |
| `GORUSH` | Go Rush. |
| `HOMERUNNER` | HomeRunner. |
| `AMAZON_ORDER` | Amazon order. |
| `EFWNOW_API` | Estes Forwarding Worldwide. |
| `CBL_LOGISTICA_API` | CBL Logistica (API). |
| `NIMBUSPOST` | NimbusPost. |
| `LOGWIN_LOGISTICS` | Logwin Logistics. |
| `NOWLOG_API` | Sequoialog. |
| `DPD_NL` | DPD Netherlands. |
| `GODEPENDABLE` | Dependable Supply Chain Services. |
| `ESDEX` | Top Ideal Express. |
| `LOGISYSTEMS_SFTP` | Kiitäjät. |
| `EXPEDITORS` | Expeditors. |
| `SNTGLOBAL_API` | Snt Global Etrax. |
| `SHIPX` | ShipX. |
| `QINTL_API` | Quickstat Courier LLC. |
| `PACKS` | Packs. |
| `POSTNL_INTERNATIONAL` | PostNL International. |
| `AMAZON_EMAIL_PUSH` | Amazon. |
| `DHL_API` | DHL. |
| `SPX` | Shopee Express. |
| `AXLEHIRE` | AxleHire. |
| `ICSCOURIER` | ICS COURIER. |
| `DIALOGO_LOGISTICA` | Dialogo Logistica. |
| `SHUNBANG_EXPRESS` | ShunBang Express. |
| `TCS_API` | TCS. |
| `SF_EXPRESS_CN` | SF Express China. |
| `PACKETA` | Packeta. |
| `SIC_TELIWAY` | Teliway SIC Express. |
| `MONDIALRELAY_FR` | Mondial Relay France. |
| `INTIME_FTP` | InTime. |
| `JD_EXPRESS` | 京东物流. |
| `FASTBOX` | Fastbox. |
| `PATHEON` | Patheon Logistics. |
| `INDIA_POST` | India Post Domestic. |
| `TIPSA_REF` | Tipsa Reference. |
| `ECOFREIGHT` | Eco Freight. |
| `VOX` | VOX SOLUCION EMPRESARIAL SRL. |
| `DIRECTFREIGHT_AU_REF` | Direct Freight Express. |
| `BESTTRANSPORT_SFTP` | Best Transport. |
| `AUSTRALIA_POST_API` | Australia Post. |
| `FRAGILEPAK_SFTP` | FragilePAK. |
| `FLIPXP` | FlipXpress. |
| `VALUE_WEBHOOK` | Value Logistics. |
| `DAESHIN` | Daeshin. |
| `SHERPA` | Sherpa. |
| `MWD_API` | Metropolitan Warehouse & Delivery. |
| `SMARTKARGO` | SmartKargo. |
| `DNJ_EXPRESS` | DNJ Express. |
| `GOPEOPLE` | Go People. |
| `MYSENDLE_API` | mySendle. |
| `ARAMEX_API` | Aramex. |
| `PIDGE` | Pidge. |
| `THAIPARCELS` | TP Logistic. |
| `PANTHER_REFERENCE_API` | Panther Reference. |
| `POSTAPLUS1` | Posta Plus. |
| `BUFFALO` | BUFFALO. |
| `U_ENVIOS` | U-ENVIOS. |
| `ELITE_CO` | Elite Express. |
| `ROCHE_INTERNAL_SFTP` | Roche Internal Courier. |
| `DBSCHENKER_ICELAND` | DB Schenker Iceland. |
| `TNT_FR_REFERENCE` | TNT France Reference. |
| `NEWGISTICSAPI` | Newgistics API. |
| `GLOVO` | Glovo. |
| `GWLOGIS_API` | G.I.G. |
| `SPREETAIL_API` | Spreetail. |
| `MOOVA` | Moova. |
| `PLYCONGROUP` | Plycon Transportation Group. |
| `USPS_WEBHOOK` | USPS Informed Visibility - Webhook. |
| `REIMAGINEDELIVERY` | maergo. |
| `EDF_FTP` | Eurodifarm. |
| `DAO365` | DAO365. |
| `BIOCAIR_FTP` | BioCair. |
| `RANSA_WEBHOOK` | Ransa. |
| `SHIPXPRES` | SHIPXPRESS. |
| `COURANT_PLUS_API` | Courant Plus. |
| `SHIPA` | SHIPA. |
| `HOMELOGISTICS` | Home Logistics. |
| `DX` | DX. |
| `POSTE_ITALIANE_PACCOCELERE` | Poste Italiane Paccocelere. |
| `TOLL_WEBHOOK` | Toll Group. |
| `LCTBR_API` | LCT do Brasil. |
| `DX_FREIGHT` | DX Freight. |
| `DHL_SFTP` | DHL Express. |
| `SHIPROCKET` | Shiprocket X. |
| `UBER_WEBHOOK` | Uber. |
| `STATOVERNIGHT` | Stat Overnight. |
| `BURD` | Burd Delivery. |
| `FASTSHIP` | Fastship Express. |
| `IBVENTURE_WEBHOOK` | IB Venture. |
| `GATI_KWE_API` | Gati-KWE. |
| `CRYOPDP_FTP` | CryoPDP. |
| `HUBBED` | HUBBED. |
| `TIPSA_API` | Tipsa API. |
| `ARASKARGO` | Aras Cargo. |
| `THIJS_NL` | Thijs Logistiek. |
| `ATSHEALTHCARE_REFERENCE` | ATS Healthcare. |
| `ENUM_99MINUTOS` | 99minutos. |
| `HELLENIC_POST` | Hellenic (Greece) Post. |
| `HSM_GLOBAL` | HSM Global. |
| `MNX` | MNX. |
| `NMTRANSFER` | N&M Transfer Co., Inc.. |
| `LOGYSTO` | Logysto. |
| `INDIA_POST_INT` | India Post International. |
| `AMAZON_FBA_SWISHIP_IN` | Swiship IN. |
| `SRT_TRANSPORT` | SRT Transport. |
| `BOMI` | Bomi Group. |
| `DELIVERR_SFTP` | Deliverr. |
| `HSDEXPRESS` | HSDEXPRESS. |
| `SIMPLETIRE_WEBHOOK` | SimpleTire. |
| `HUNTER_EXPRESS_SFTP` | Hunter Express. |
| `UPS_API` | UPS. |
| `WOOYOUNG_LOGISTICS_SFTP` | WOO YOUNG LOGISTICS CO.,LTD.. |
| `PHSE_API` | PHSE. |
| `WISH_EMAIL_PUSH` | Wish. |
| `NORTHLINE` | Northline. |
| `MEDAFRICA` | Med Africa Logistics. |
| `DPD_AT_SFTP` | DPD Austria. |
| `ANTERAJA` | Anteraja. |
| `DHL_GLOBAL_FORWARDING_API` | DHL Global Forwarding API. |
| `LBCEXPRESS_API` | LBC EXPRESS INC.. |
| `SIMSGLOBAL` | Sims Global. |
| `CDLDELIVERS` | CDL Last Mile. |
| `TYP` | TYP. |
| `TESTING_COURIER_WEBHOOK` | Testing Courier. |
| `PANDAGO_API` | Pandago. |
| `ROYAL_MAIL_FTP` | Royal Mail. |
| `THUNDEREXPRESS` | Thunder Express Australia. |
| `SECRETLAB_WEBHOOK` | Secretlab. |
| `SETEL` | Setel Express. |
| `JD_WORLDWIDE` | JD Worldwide. |
| `DPD_RU_API` | DPD Russia. |
| `ARGENTS_WEBHOOK` | Argents Express Group. |
| `POSTONE` | Post ONE. |
| `TUSKLOGISTICS` | Tusk Logistics. |
| `RHENUS_UK_API` | Rhenus Logistics UK. |
| `TAQBIN_SG_API` | Yamato Singapore. |
| `INNTRALOG_SFTP` | Inntralog GmbH. |
| `DAYROSS` | Day & Ross. |
| `CORREOSEXPRESS_API` | Correos Express (API). |
| `INTERNATIONAL_SEUR_API` | International Seur API. |
| `YODEL_API` | Yodel API. |
| `HEROEXPRESS` | Hero Express. |
| `DHL_SUPPLYCHAIN_IN` | DHL supply chain India. |
| `URGENT_CARGUS` | Urgent Cargus. |
| `FRONTDOORCORP` | FRONTdoor Collective. |
| `JTEXPRESS_PH` | J&T Express Philippines. |
| `PARCELSTARS_WEBHOOK` | Parcelstars. |
| `DPD_SK_SFTP` | DPD Slovakia. |
| `MOVIANTO` | Movianto. |
| `OZEPARTS_SHIPPING` | Ozeparts Shipping. |
| `KARGOMKOLAY` | KargomKolay (CargoMini). |
| `TRUNKRS` | Trunkrs. |
| `OMNIRPS_WEBHOOK` | Omni Returns. |
| `CHILEXPRESS` | Chile Express. |
| `TESTING_COURIER` | Testing Courier. |
| `JNE_API` | JNE (API). |
| `BJSHOMEDELIVERY_FTP` | BJS Distribution, Storage & Couriers - FTP. |
| `DEXPRESS_WEBHOOK` | D Express. |
| `USPS_API` | USPS API. |
| `TRANSVIRTUAL` | TransVirtual. |
| `SOLISTICA_API` | solistica. |
| `CHIENVENTURE_WEBHOOK` | Chienventure. |
| `DPD_UK_SFTP` | DPD UK. |
| `INPOST_UK` | InPost. |
| `JAVIT` | Javit. |
| `ZTO_DOMESTIC` | ZTO Express China. |
| `DHL_GT_API` | DHL Global Forwarding Guatemala. |
| `CEVA_TRACKING` | CEVA Package. |
| `KOMON_EXPRESS` | Komon Express. |
| `EASTWESTCOURIER_FTP` | East West Courier Pte Ltd. |
| `DANNIAO` | Danniao. |
| `SPECTRAN` | Spectran. |
| `DELIVER_IT` | Deliver-iT. |
| `RELAISCOLIS` | Relais Colis. |
| `GLS_SPAIN_API` | GLS Spain. |
| `POSTPLUS` | PostPlus. |
| `AIRTERRA` | Airterra. |
| `GIO_ECOURIER_API` | GIO Express Ecourier. |
| `DPD_CH_SFTP` | DPD Switzerland. |
| `FEDEX_API` | FedEx®. |
| `INTERSMARTTRANS` | INTERSMARTTRANS & SOLUTIONS SL. |
| `HERMES_UK_SFTP` | Hermes UK. |
| `EXELOT_FTP` | Exelot Ltd.. |
| `DHL_PA_API` | DHL GLOBAL FORWARDING PANAMÁ. |
| `VIRTRANSPORT_SFTP` | Vir Transport. |
| `WORLDNET` | Worldnet Logistics. |
| `INSTABOX_WEBHOOK` | Instabox. |
| `KNG` | Keuhne + Nagel Global. |
| `FLASHEXPRESS_WEBHOOK` | Flash Express. |
| `MAGYAR_POSTA_API` | Magyar Posta. |
| `WESHIP_API` | WeShip. |
| `OHI_WEBHOOK` | Ohi. |
| `MUDITA` | MUDITA. |
| `BLUEDART_API` | Bluedart. |
| `T_CAT_API` | T-cat. |
| `ADS` | ADS Express. |
| `HERMES_IT` | HR Parcel. |
| `FITZMARK_API` | FitzMark. |
| `POSTI_API` | Posti API. |
| `SMSA_EXPRESS_WEBHOOK` | SMSA Express. |
| `TAMERGROUP_WEBHOOK` | Tamer Logistics. |
| `LIVRAPIDE` | Livrapide. |
| `NIPPON_EXPRESS` | Nippon Express. |
| `BETTERTRUCKS` | Better Trucks. |
| `FAN` | FAN COURIER EXPRESS. |
| `PB_USPSFLATS_FTP` | USPS Flats (Pitney Bowes). |
| `PARCELRIGHT` | Parcel Right. |
| `ITHINKLOGISTICS` | iThink Logistics. |
| `KERRY_EXPRESS_TH_WEBHOOK` | Kerry Logistics. |
| `ECOUTIER` | eCoutier. |
| `SHOWL` | SENHONG INTERNATIONAL LOGISTICS. |
| `BRT_IT_API` | BRT Bartolini API. |
| `RIXONHK_API` | Rixon Logistics. |
| `DBSCHENKER_API` | DB Schenker. |
| `ILYANGLOGIS` | Ilyang logistics. |
| `MAIL_BOX_ETC` | Mail Boxes Etc.. |
| `WESHIP` | WeShip. |
| `DHL_GLOBAL_MAIL_API` | DHL eCommerce Solutions. |
| `ACTIVOS24_API` | Activos24. |
| `ATSHEALTHCARE` | ATS Healthcare. |
| `LUWJISTIK` | Luwjistik. |
| `GW_WORLD` | Gebrüder Weiss. |
| `FAIRSENDEN_API` | fairsenden. |
| `SERVIP_WEBHOOK` | SerVIP. |
| `SWISHIP` | Swiship. |
| `TANET` | Transport Ambientales. |
| `HOTSIN_CARGO` | SHENZHEN HOTSIN CARGO INT'L FORWARDING CO.,LTD. |
| `DIREX` | Direx. |
| `HUANTONG` | HuanTong. |
| `IMILE_API` | iMile. |
| `AUEXPRESS` | Au Express. |
| `NYTLOGISTICS` | NYT SUPPLY CHAIN LOGISTICS Co.,LTD. |
| `DSV_REFERENCE` | DSV Futurewave. |
| `NOVOFARMA_WEBHOOK` | Novofarma. |
| `AITWORLDWIDE_SFTP` | AIT. |
| `SHOPOLIVE` | Olive. |
| `FNF_ZA` | Fast & Furious. |
| `DHL_ECOMMERCE_GC` | DHL eCommerce Greater China. |
| `FETCHR` | Fetchr. |
| `STARLINKS_API` | Starlinks Global. |
| `YYEXPRESS` | YYEXPRESS. |
| `SERVIENTREGA` | Servientrega. |
| `HANJIN` | HanJin. |
| `SPANISH_SEUR_FTP` | Spanish Seur. |
| `DX_B2B_CONNUM` | DX (B2B). |
| `HELTHJEM_API` | Helthjem. |
| `INEXPOST` | Inexpost. |
| `A2B_BA` | A2B Express Logistics. |
| `RHENUS_GROUP` | Rhenus Logistics. |
| `SBERLOGISTICS_RU` | Sber Logistics. |
| `MALCA_AMIT` | Malca-Amit. |
| `PPL` | Professional Parcel Logistics. |
| `OSM_WORLDWIDE_SFTP` | OSM Worldwide. |
| `ACILOGISTIX` | ACI Logistix. |
| `OPTIMACOURIER` | Optima Courier. |
| `NOVA_POSHTA_API` | Nova Poshta API. |
| `LOGGI` | Loggi. |
| `YIFAN` | YiFan Express. |
| `MYDYNALOGIC` | My DynaLogic. |
| `MORNINGLOBAL` | Morning Global. |
| `CONCISE_API` | Concise. |
| `FXTRAN` | Falcon Express. |
| `DELIVERYOURPARCEL_ZA` | Deliver Your Parcel. |
| `UPARCEL` | uParcel. |
| `MOBI_BR` | Mobi Logistica. |
| `LOGINEXT_WEBHOOK` | T&W Delivery. |
| `EMS` | EMS. |
| `SPEEDY` | Speedy. |
| `ZOOM_RED` | Zoom. |
| `NAVLUNGO` | Navlungo. |
| `CASTLEPARCELS` | Castle Parcels. |
| `WEEE` | Weee. |
| `PACKALY` | Packaly. |
| `YUNHUIPOST` | Yunhuipost. |
| `YOUPARCEL` | YouParcel. |
| `LEMAN` | Leman. |
| `MOOVIN` | Moovin. |
| `URB_IT` | Urb-it. |
| `MULTIENTREGAPANAMA` | Multientrega. |
| `JUSDASR` | Jusdasr. |
| `DISCOUNTPOST` | Discount Post. |
| `RHENUS_UK` | Rhenus Logistics UK. |
| `SWISHIP_JP` | Swiship JP. |
| `GLS_US` | GLS USA. |
| `SMTL` | Southwestern Motor Transport. Inc. |
| `EMEGA` | Discount Post Emega. |
| `EXPRESSONE_SV` | EXPRESSONE Slovenia. |
| `HEPSIJET` | hepsiJET. |
| `WELIVERY` | Welivery. |
| `BRINGER` | Bringer Parcel Services. |
| `EASYROUTES` | EasyRoutes. |
| `MRW` | MRW. |
| `RPM` | RPM. |
| `DPD_PRT` | DPD Portugal. |
| `GLS_ROMANIA` | GLS Romania. |
| `LMPARCEL` | LM Parcel. |
| `GTAGSM` | GTA GSM. |
| `DOMINO` | DOMINO. |
| `ESHIPPER` | eShipper. |
| `TRANSPAK` | Transpak Inc.. |
| `XINDUS` | Xindus. |
| `AOYUE` | Aoyue. |
| `EASYPARCEL` | Easyparcel. |
| `EXPRESSONE` | EXPRESSONE. |
| `SENDEO_KARGO` | Sendeo Kargo. |
| `SPEEDAF` | Speedaf Express. |
| `ETOWER` | eTower. |
| `GCX` | GC Express. |
| `NINJAVAN_VN` | Ninjavan Vietnam. |
| `ALLEGRO` | Allegro. |
| `JUMPPOINT` | Jumppoint. |
| `SHIPGLOBAL_US` | ShipGlobal. |
| `KINISI` | Kinisi Transport Pty Ltd. |
| `OAKH` | Oakh Harbour Freight Lines. |
| `AWEST` | American West. |
| `BARSAN` | Barsan Global Lojistik. |
| `ENERGOLOGISTIC` | Energo Logistic. |
| `MADROOEX` | Madrooex. |
| `GOBOLT` | GoBolt. |
| `SWISS_UNIVERSAL_EXPRESS` | Swiss Universal Express. |
| `IORDIRECT` | IOR Direct Solutions. |
| `XMSZM` | xmszm. |
| `GLS_HUN` | GLS Hungary. |
| `SENDY` | Sendy Express. |
| `BRAUNSEXPRESS` | Brauns Express. |
| `GRANDSLAMEXPRESS` | Grand Slam Express. |
| `XGS` | XGS. |
| `OTSCHILE` | OTS. |
| `PACK_UP` | Pack-Up. |
| `PARCELSTARS` | Parcelstars. |
| `TEAMEXPRESSLLC` | Team Express Service LLC. |
| `ASYADEXPRESS` | Asyad Express. |
| `TDN` | TDN. |
| `EARLYBIRD` | Early Bird. |
| `CACESA` | Cacesa. |
| `PARCELJET` | Parceljet. |
| `MNG_KARGO` | MNG Kargo. |
| `SUPERPACKLINE` | Super Pac Line. |
| `SPEEDX` | SpeedX. |
| `VESYL` | Vesyl. |
| `SKYKING` | Sky King. |
| `DIRMENSAJERIA` | DIR. |
| `NETLOGIXGROUP` | Netlogix. |
| `ZYOU` | ZYEX. |
| `JAWAR` | Jawar. |
| `AGSYSTEMS` | Associate Global Systems. |
| `GPS` | GPS. |
| `PTT_KARGO` | PTT Kargo. |
| `MAERGO` | Maergo. |
| `ARIHANTCOURIER` | AICS. |
| `VTFE` | VicTas Freight Express. |
| `YUNANT` | Yunant. |
| `URBIFY` | Urbify. |
| `PACK_MAN` | pack-man. |
| `LIEFERGRUN` | LIEFERGRUN. |
| `OBIBOX` | Obibox. |
| `PAIKEDA` | Paikeda. |
| `SCOTTY` | Scotty. |
| `INTELCOM_CA` | Intelcom. |
| `SWE` | swe. |
| `ASENDIA` | Asendia Global. |
| `DPD_AT` | DPD Austria. |
| `RELAY` | Relay. |
| `ATA` | ATA. |
| `SKYEXPRESS_INTERNATIONAL` | SkyExpress Internationals. |
| `SURAT_KARGO` | Surat Kargo. |
| `SGLINK` | SG LINK. |
| `FLEETOPTICSINC` | FleetOptics. |
| `SHOPLINE` | shopline. |
| `PIGGYSHIP` | PIGGYSHIP. |
| `LOGOIX` | LogoiX. |
| `KOLAY_GELSIN` | Kolay Gelsin. |
| `ASSOCIATED_COURIERS` | Associated Couriers. |
| `UPS_CHECKER` | ups-checker. |
| `WINESHIPPING` | Wineshipping. |
| `SPEDISCI` | Spedisci online. |
| `FOURKITES` | Fourkites. |
| `ETONAS` | Etonas. |
| `FINMILE` | Fin Mile. |
| `UNIUNI` | Uniuni. |
| `RODONAVES` | Rodonaves. |
| `INPOST_IT` | Inpost Italy. |
| `TFORCE_FREIGHT` | Tforce Freight. |
| `RICHMOM` | Rich Mom. |
| `FRANCO` | Corriere Franco. |
| `ECPARCEL` | Ecparcel. |
| `FEDEX_CHINA` | Fedex China. |
| `GOFO_EXPRESS` | Gofo Express. |
| `SHIPBOB` | Shipbob. |
| `JERSEYPOST_ATLAS` | Jersey Post Group. |
| `CORETRAILS` | Coretrails. |
| `RHENUS_ITALY` | Rhenus Logistics Italy. |
| `JADLOG` | Jadlog. |
| `JITSU` | Jitsu. |
| `YANWEN_EXPRESS` | Yanwen Express. |
| `DASHLINK` | Dashlink. |
| `SEINO_SUPER_EXPRESS` | Seino Super Express. |
| `FLOSHIP` | Floship. |
| `METROSCG` | Metro Supply Chain. |
| `SENDPARCEL` | Sendparcel. |
| `P2P` | P2p. |
| `CN_EXPRESS` | Cn Express. |
| `CIRROTRACK` | Cirro Track. |
| `LAND_LOGISTICS` | Land Logistics. |
| `VEHO` | Veho. |
| `MEDLINE` | Medline. |
| `VDTRACK` | Vdtrack. |
| `SINO_SCM` | Sino Scm. |
| `ENUM_3PE_EXPRESS` | 3pe Express. |
| `SWIFTX` | Swiftx. |
| `SFYDEXPRESS` | Sfyd Express. |
| `TOPTRANS` | Toptrans. |

