<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\ApplePayRequestCard;

/**
 * Builder for model ApplePayRequestCard
 *
 * @see ApplePayRequestCard
 */
class ApplePayRequestCardBuilder
{
    /**
     * @var ApplePayRequestCard
     */
    private $instance;

    private function __construct(ApplePayRequestCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Apple Pay Request Card Builder object.
     */
    public static function init(): self
    {
        return new self(new ApplePayRequestCard());
    }

    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets brand field.
     *
     * @param string|null $value
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     *
     * @param Address|null $value
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Initializes a new Apple Pay Request Card object.
     */
    public function build(): ApplePayRequestCard
    {
        return CoreHelper::clone($this->instance);
    }
}
