<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\BankRequest;
use PaypalServerSdkLib\Models\SepaDebitRequest;

/**
 * Builder for model BankRequest
 *
 * @see BankRequest
 */
class BankRequestBuilder
{
    /**
     * @var BankRequest
     */
    private $instance;

    private function __construct(BankRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Bank Request Builder object.
     */
    public static function init(): self
    {
        return new self(new BankRequest());
    }

    /**
     * Sets ach debit field.
     *
     * @param mixed $value
     */
    public function achDebit($value): self
    {
        $this->instance->setAchDebit($value);
        return $this;
    }

    /**
     * Sets sepa debit field.
     *
     * @param SepaDebitRequest|null $value
     */
    public function sepaDebit(?SepaDebitRequest $value): self
    {
        $this->instance->setSepaDebit($value);
        return $this;
    }

    /**
     * Initializes a new Bank Request object.
     */
    public function build(): BankRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
