<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PricingTier;

/**
 * Builder for model PricingTier
 *
 * @see PricingTier
 */
class PricingTierBuilder
{
    /**
     * @var PricingTier
     */
    private $instance;

    private function __construct(PricingTier $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Pricing Tier Builder object.
     *
     * @param string $startingQuantity
     * @param Money $amount
     */
    public static function init(string $startingQuantity, Money $amount): self
    {
        return new self(new PricingTier($startingQuantity, $amount));
    }

    /**
     * Sets ending quantity field.
     *
     * @param string|null $value
     */
    public function endingQuantity(?string $value): self
    {
        $this->instance->setEndingQuantity($value);
        return $this;
    }

    /**
     * Initializes a new Pricing Tier object.
     */
    public function build(): PricingTier
    {
        return CoreHelper::clone($this->instance);
    }
}
