<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VaultedDigitalWalletShippingDetails;
use PaypalServerSdkLib\Models\VaultVenmoRequest;
use PaypalServerSdkLib\Models\VenmoExperienceContext;

/**
 * Builder for model VaultVenmoRequest
 *
 * @see VaultVenmoRequest
 */
class VaultVenmoRequestBuilder
{
    /**
     * @var VaultVenmoRequest
     */
    private $instance;

    private function __construct(VaultVenmoRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Vault Venmo Request Builder object.
     */
    public static function init(): self
    {
        return new self(new VaultVenmoRequest());
    }

    /**
     * Sets description field.
     *
     * @param string|null $value
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets usage pattern field.
     *
     * @param string|null $value
     */
    public function usagePattern(?string $value): self
    {
        $this->instance->setUsagePattern($value);
        return $this;
    }

    /**
     * Sets shipping field.
     *
     * @param VaultedDigitalWalletShippingDetails|null $value
     */
    public function shipping(?VaultedDigitalWalletShippingDetails $value): self
    {
        $this->instance->setShipping($value);
        return $this;
    }

    /**
     * Sets permit multiple payment tokens field.
     *
     * @param bool|null $value
     */
    public function permitMultiplePaymentTokens(?bool $value): self
    {
        $this->instance->setPermitMultiplePaymentTokens($value);
        return $this;
    }

    /**
     * Sets usage type field.
     *
     * @param string|null $value
     */
    public function usageType(?string $value): self
    {
        $this->instance->setUsageType($value);
        return $this;
    }

    /**
     * Sets customer type field.
     *
     * @param string|null $value
     */
    public function customerType(?string $value): self
    {
        $this->instance->setCustomerType($value);
        return $this;
    }

    /**
     * Sets experience context field.
     *
     * @param VenmoExperienceContext|null $value
     */
    public function experienceContext(?VenmoExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new Vault Venmo Request object.
     */
    public function build(): VaultVenmoRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
