<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\VenmoWalletAdditionalAttributes;
use PaypalServerSdkLib\Models\VenmoWalletCustomerInformation;
use PaypalServerSdkLib\Models\VenmoWalletVaultAttributes;

/**
 * Builder for model VenmoWalletAdditionalAttributes
 *
 * @see VenmoWalletAdditionalAttributes
 */
class VenmoWalletAdditionalAttributesBuilder
{
    /**
     * @var VenmoWalletAdditionalAttributes
     */
    private $instance;

    private function __construct(VenmoWalletAdditionalAttributes $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new Venmo Wallet Additional Attributes Builder object.
     */
    public static function init(): self
    {
        return new self(new VenmoWalletAdditionalAttributes());
    }

    /**
     * Sets customer field.
     *
     * @param VenmoWalletCustomerInformation|null $value
     */
    public function customer(?VenmoWalletCustomerInformation $value): self
    {
        $this->instance->setCustomer($value);
        return $this;
    }

    /**
     * Sets vault field.
     *
     * @param VenmoWalletVaultAttributes|null $value
     */
    public function vault(?VenmoWalletVaultAttributes $value): self
    {
        $this->instance->setVault($value);
        return $this;
    }

    /**
     * Initializes a new Venmo Wallet Additional Attributes object.
     */
    public function build(): VenmoWalletAdditionalAttributes
    {
        return CoreHelper::clone($this->instance);
    }
}
