<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * OAuth 2 Authorization endpoint response
 */
class OAuthToken implements \JsonSerializable
{
    /**
     * @var string
     */
    private $accessToken;

    /**
     * @var string
     */
    private $tokenType;

    /**
     * @var int|null
     */
    private $expiresIn;

    /**
     * @var string|null
     */
    private $scope;

    /**
     * @var int|null
     */
    private $expiry;

    /**
     * @var string|null
     */
    private $refreshToken;

    /**
     * @var string|null
     */
    private $idToken;

    /**
     * @param string $accessToken
     * @param string $tokenType
     */
    public function __construct(string $accessToken, string $tokenType)
    {
        $this->accessToken = $accessToken;
        $this->tokenType = $tokenType;
    }

    /**
     * Returns Access Token.
     * Access token
     */
    public function getAccessToken(): string
    {
        return $this->accessToken;
    }

    /**
     * Sets Access Token.
     * Access token
     *
     * @required
     * @maps access_token
     */
    public function setAccessToken(string $accessToken): void
    {
        $this->accessToken = $accessToken;
    }

    /**
     * Returns Token Type.
     * Type of access token
     */
    public function getTokenType(): string
    {
        return $this->tokenType;
    }

    /**
     * Sets Token Type.
     * Type of access token
     *
     * @required
     * @maps token_type
     */
    public function setTokenType(string $tokenType): void
    {
        $this->tokenType = $tokenType;
    }

    /**
     * Returns Expires In.
     * Time in seconds before the access token expires
     */
    public function getExpiresIn(): ?int
    {
        return $this->expiresIn;
    }

    /**
     * Sets Expires In.
     * Time in seconds before the access token expires
     *
     * @maps expires_in
     */
    public function setExpiresIn(?int $expiresIn): void
    {
        $this->expiresIn = $expiresIn;
    }

    /**
     * Returns Scope.
     * List of scopes granted
     * This is a space-delimited list of strings.
     */
    public function getScope(): ?string
    {
        return $this->scope;
    }

    /**
     * Sets Scope.
     * List of scopes granted
     * This is a space-delimited list of strings.
     *
     * @maps scope
     */
    public function setScope(?string $scope): void
    {
        $this->scope = $scope;
    }

    /**
     * Returns Expiry.
     * Time of token expiry as unix timestamp (UTC)
     */
    public function getExpiry(): ?int
    {
        return $this->expiry;
    }

    /**
     * Sets Expiry.
     * Time of token expiry as unix timestamp (UTC)
     *
     * @maps expiry
     */
    public function setExpiry(?int $expiry): void
    {
        $this->expiry = $expiry;
    }

    /**
     * Returns Refresh Token.
     * Refresh token
     * Used to get a new access token when it expires.
     */
    public function getRefreshToken(): ?string
    {
        return $this->refreshToken;
    }

    /**
     * Sets Refresh Token.
     * Refresh token
     * Used to get a new access token when it expires.
     *
     * @maps refresh_token
     */
    public function setRefreshToken(?string $refreshToken): void
    {
        $this->refreshToken = $refreshToken;
    }

    /**
     * Returns Id Token.
     * An ID token response type is of JSON Web Token (JWT) that contains claims about the identity of the
     * authenticated user.
     */
    public function getIdToken(): ?string
    {
        return $this->idToken;
    }

    /**
     * Sets Id Token.
     * An ID token response type is of JSON Web Token (JWT) that contains claims about the identity of the
     * authenticated user.
     *
     * @maps id_token
     */
    public function setIdToken(?string $idToken): void
    {
        $this->idToken = $idToken;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['access_token']      = $this->accessToken;
        $json['token_type']        = $this->tokenType;
        if (isset($this->expiresIn)) {
            $json['expires_in']    = $this->expiresIn;
        }
        if (isset($this->scope)) {
            $json['scope']         = $this->scope;
        }
        if (isset($this->expiry)) {
            $json['expiry']        = $this->expiry;
        }
        if (isset($this->refreshToken)) {
            $json['refresh_token'] = $this->refreshToken;
        }
        if (isset($this->idToken)) {
            $json['id_token']      = $this->idToken;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
