<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * Customizes the payer experience during the approval process for payment with PayPal. Note: Partners
 * and Marketplaces might configure brand_name and shipping_preference during partner account setup,
 * which overrides the request values.
 */
class PaypalWalletExperienceContext implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $brandName;

    /**
     * @var string|null
     */
    private $locale;

    /**
     * @var string|null
     */
    private $shippingPreference = PaypalWalletContextShippingPreference::GET_FROM_FILE;

    /**
     * @var string|null
     */
    private $contactPreference = PaypalWalletContactPreference::NO_CONTACT_INFO;

    /**
     * @var string|null
     */
    private $returnUrl;

    /**
     * @var string|null
     */
    private $cancelUrl;

    /**
     * @var AppSwitchContext|null
     */
    private $appSwitchContext;

    /**
     * @var string|null
     */
    private $landingPage = PaypalExperienceLandingPage::NO_PREFERENCE;

    /**
     * @var string|null
     */
    private $userAction = PaypalExperienceUserAction::CONTINUE_;

    /**
     * @var string|null
     */
    private $paymentMethodPreference = PayeePaymentMethodPreference::UNRESTRICTED;

    /**
     * @var CallbackConfiguration|null
     */
    private $orderUpdateCallbackConfig;

    /**
     * Returns Brand Name.
     * The label that overrides the business name in the PayPal account on the PayPal site. The pattern is
     * defined by an external party and supports Unicode.
     */
    public function getBrandName(): ?string
    {
        return $this->brandName;
    }

    /**
     * Sets Brand Name.
     * The label that overrides the business name in the PayPal account on the PayPal site. The pattern is
     * defined by an external party and supports Unicode.
     *
     * @maps brand_name
     */
    public function setBrandName(?string $brandName): void
    {
        $this->brandName = $brandName;
    }

    /**
     * Returns Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag is made
     * up of the [ISO 639-2 language code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the
     * optional [ISO-15924 script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166
     * alpha-2 country code](/api/rest/reference/country-codes/) or [M49 region code](https://unstats.un.
     * org/unsd/methodology/m49/).
     */
    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * Sets Locale.
     * The [language tag](https://tools.ietf.org/html/bcp47#section-2) for the language in which to
     * localize the error-related strings, such as messages, issues, and suggested actions. The tag is made
     * up of the [ISO 639-2 language code](https://www.loc.gov/standards/iso639-2/php/code_list.php), the
     * optional [ISO-15924 script tag](https://www.unicode.org/iso15924/codelists.html), and the [ISO-3166
     * alpha-2 country code](/api/rest/reference/country-codes/) or [M49 region code](https://unstats.un.
     * org/unsd/methodology/m49/).
     *
     * @maps locale
     */
    public function setLocale(?string $locale): void
    {
        $this->locale = $locale;
    }

    /**
     * Returns Shipping Preference.
     * The location from which the shipping address is derived.
     */
    public function getShippingPreference(): ?string
    {
        return $this->shippingPreference;
    }

    /**
     * Sets Shipping Preference.
     * The location from which the shipping address is derived.
     *
     * @maps shipping_preference
     */
    public function setShippingPreference(?string $shippingPreference): void
    {
        $this->shippingPreference = $shippingPreference;
    }

    /**
     * Returns Contact Preference.
     * The preference to display the contact information (buyer’s shipping email & phone number) on
     * PayPal's checkout for easy merchant-buyer communication.
     */
    public function getContactPreference(): ?string
    {
        return $this->contactPreference;
    }

    /**
     * Sets Contact Preference.
     * The preference to display the contact information (buyer’s shipping email & phone number) on
     * PayPal's checkout for easy merchant-buyer communication.
     *
     * @maps contact_preference
     */
    public function setContactPreference(?string $contactPreference): void
    {
        $this->contactPreference = $contactPreference;
    }

    /**
     * Returns Return Url.
     * Describes the URL.
     */
    public function getReturnUrl(): ?string
    {
        return $this->returnUrl;
    }

    /**
     * Sets Return Url.
     * Describes the URL.
     *
     * @maps return_url
     */
    public function setReturnUrl(?string $returnUrl): void
    {
        $this->returnUrl = $returnUrl;
    }

    /**
     * Returns Cancel Url.
     * Describes the URL.
     */
    public function getCancelUrl(): ?string
    {
        return $this->cancelUrl;
    }

    /**
     * Sets Cancel Url.
     * Describes the URL.
     *
     * @maps cancel_url
     */
    public function setCancelUrl(?string $cancelUrl): void
    {
        $this->cancelUrl = $cancelUrl;
    }

    /**
     * Returns App Switch Context.
     * Merchant provided details of the native app or mobile web browser to facilitate buyer's app switch
     * to the PayPal consumer app.
     */
    public function getAppSwitchContext(): ?AppSwitchContext
    {
        return $this->appSwitchContext;
    }

    /**
     * Sets App Switch Context.
     * Merchant provided details of the native app or mobile web browser to facilitate buyer's app switch
     * to the PayPal consumer app.
     *
     * @maps app_switch_context
     */
    public function setAppSwitchContext(?AppSwitchContext $appSwitchContext): void
    {
        $this->appSwitchContext = $appSwitchContext;
    }

    /**
     * Returns Landing Page.
     * The type of landing page to show on the PayPal site for customer checkout.
     */
    public function getLandingPage(): ?string
    {
        return $this->landingPage;
    }

    /**
     * Sets Landing Page.
     * The type of landing page to show on the PayPal site for customer checkout.
     *
     * @maps landing_page
     */
    public function setLandingPage(?string $landingPage): void
    {
        $this->landingPage = $landingPage;
    }

    /**
     * Returns User Action.
     * Configures a Continue or Pay Now checkout flow.
     */
    public function getUserAction(): ?string
    {
        return $this->userAction;
    }

    /**
     * Sets User Action.
     * Configures a Continue or Pay Now checkout flow.
     *
     * @maps user_action
     */
    public function setUserAction(?string $userAction): void
    {
        $this->userAction = $userAction;
    }

    /**
     * Returns Payment Method Preference.
     * The merchant-preferred payment methods.
     */
    public function getPaymentMethodPreference(): ?string
    {
        return $this->paymentMethodPreference;
    }

    /**
     * Sets Payment Method Preference.
     * The merchant-preferred payment methods.
     *
     * @maps payment_method_preference
     */
    public function setPaymentMethodPreference(?string $paymentMethodPreference): void
    {
        $this->paymentMethodPreference = $paymentMethodPreference;
    }

    /**
     * Returns Order Update Callback Config.
     * CallBack Configuration that the merchant can provide to PayPal/Venmo.
     */
    public function getOrderUpdateCallbackConfig(): ?CallbackConfiguration
    {
        return $this->orderUpdateCallbackConfig;
    }

    /**
     * Sets Order Update Callback Config.
     * CallBack Configuration that the merchant can provide to PayPal/Venmo.
     *
     * @maps order_update_callback_config
     */
    public function setOrderUpdateCallbackConfig(?CallbackConfiguration $orderUpdateCallbackConfig): void
    {
        $this->orderUpdateCallbackConfig = $orderUpdateCallbackConfig;
    }

    /**
     * Converts the PaypalWalletExperienceContext object to a human-readable string representation.
     *
     * @return string The string representation of the PaypalWalletExperienceContext object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PaypalWalletExperienceContext',
            [
                'brandName' => $this->brandName,
                'locale' => $this->locale,
                'shippingPreference' => $this->shippingPreference,
                'contactPreference' => $this->contactPreference,
                'returnUrl' => $this->returnUrl,
                'cancelUrl' => $this->cancelUrl,
                'appSwitchContext' => $this->appSwitchContext,
                'landingPage' => $this->landingPage,
                'userAction' => $this->userAction,
                'paymentMethodPreference' => $this->paymentMethodPreference,
                'orderUpdateCallbackConfig' => $this->orderUpdateCallbackConfig
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->brandName)) {
            $json['brand_name']                   = $this->brandName;
        }
        if (isset($this->locale)) {
            $json['locale']                       = $this->locale;
        }
        if (isset($this->shippingPreference)) {
            $json['shipping_preference']          = $this->shippingPreference;
        }
        if (isset($this->contactPreference)) {
            $json['contact_preference']           = $this->contactPreference;
        }
        if (isset($this->returnUrl)) {
            $json['return_url']                   = $this->returnUrl;
        }
        if (isset($this->cancelUrl)) {
            $json['cancel_url']                   = $this->cancelUrl;
        }
        if (isset($this->appSwitchContext)) {
            $json['app_switch_context']           = $this->appSwitchContext;
        }
        if (isset($this->landingPage)) {
            $json['landing_page']                 = $this->landingPage;
        }
        if (isset($this->userAction)) {
            $json['user_action']                  = $this->userAction;
        }
        if (isset($this->paymentMethodPreference)) {
            $json['payment_method_preference']    = $this->paymentMethodPreference;
        }
        if (isset($this->orderUpdateCallbackConfig)) {
            $json['order_update_callback_config'] = $this->orderUpdateCallbackConfig;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
