<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use PaypalServerSdkLib\ApiHelper;
use stdClass;

/**
 * An inline plan object to customise the subscription. You can override plan level default attributes
 * by providing customised values for the subscription in this object.
 */
class PlanOverride implements \JsonSerializable
{
    /**
     * @var BillingCycleOverride[]|null
     */
    private $billingCycles;

    /**
     * @var PaymentPreferencesOverride|null
     */
    private $paymentPreferences;

    /**
     * @var TaxesOverride|null
     */
    private $taxes;

    /**
     * Returns Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. The subscription billing cycle
     * definition has to adhere to the plan billing cycle definition.
     *
     * @return BillingCycleOverride[]|null
     */
    public function getBillingCycles(): ?array
    {
        return $this->billingCycles;
    }

    /**
     * Sets Billing Cycles.
     * An array of billing cycles for trial billing and regular billing. The subscription billing cycle
     * definition has to adhere to the plan billing cycle definition.
     *
     * @maps billing_cycles
     *
     * @param BillingCycleOverride[]|null $billingCycles
     */
    public function setBillingCycles(?array $billingCycles): void
    {
        $this->billingCycles = $billingCycles;
    }

    /**
     * Returns Payment Preferences.
     * The payment preferences to override at subscription level.
     */
    public function getPaymentPreferences(): ?PaymentPreferencesOverride
    {
        return $this->paymentPreferences;
    }

    /**
     * Sets Payment Preferences.
     * The payment preferences to override at subscription level.
     *
     * @maps payment_preferences
     */
    public function setPaymentPreferences(?PaymentPreferencesOverride $paymentPreferences): void
    {
        $this->paymentPreferences = $paymentPreferences;
    }

    /**
     * Returns Taxes.
     * The tax details.
     */
    public function getTaxes(): ?TaxesOverride
    {
        return $this->taxes;
    }

    /**
     * Sets Taxes.
     * The tax details.
     *
     * @maps taxes
     */
    public function setTaxes(?TaxesOverride $taxes): void
    {
        $this->taxes = $taxes;
    }

    /**
     * Converts the PlanOverride object to a human-readable string representation.
     *
     * @return string The string representation of the PlanOverride object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'PlanOverride',
            [
                'billingCycles' => $this->billingCycles,
                'paymentPreferences' => $this->paymentPreferences,
                'taxes' => $this->taxes
            ]
        );
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->billingCycles)) {
            $json['billing_cycles']      = $this->billingCycles;
        }
        if (isset($this->paymentPreferences)) {
            $json['payment_preferences'] = $this->paymentPreferences;
        }
        if (isset($this->taxes)) {
            $json['taxes']               = $this->taxes;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
